/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb;

import java.util.ArrayList;
import java.util.List;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.FilterOpExp;
import org.delia.compiler.ast.FilterOpFullExp;
import org.delia.compiler.ast.IdentExp;
import org.delia.compiler.astx.XNAFMultiExp;
import org.delia.db.QuerySpec;
import org.delia.db.memdb.RowSelectorBase;
import org.delia.db.memdb.filter.InEvaluator;
import org.delia.db.memdb.filter.MultiOpEvaluator;
import org.delia.db.memdb.filter.OpEvaluator;
import org.delia.db.memdb.filter.OpFactory;
import org.delia.error.ErrorTracker;
import org.delia.type.DStructType;
import org.delia.type.DType;
import org.delia.type.DTypeRegistry;
import org.delia.type.DValue;
import org.delia.util.DValueHelper;

public class OpRowSelector
extends RowSelectorBase {
    private OpEvaluator evaluator;

    @Override
    public void init(ErrorTracker et, QuerySpec spec, DStructType dtype, DTypeRegistry registry) {
        super.init(et, spec, dtype, registry);
        FilterOpFullExp fullexp = (FilterOpFullExp)this.filter.cond;
        if (fullexp.isSingleFilterOpExp()) {
            this.initSingleOpExpression(fullexp, dtype);
        } else if (fullexp.isSingleQueryInExp()) {
            this.initSingleInExpression(fullexp, dtype);
        } else {
            this.initMultipleOpExpression(fullexp, dtype);
        }
    }

    private void initMultipleOpExpression(FilterOpFullExp fullexp, DStructType dtype) {
        this.evaluator = new MultiOpEvaluator(fullexp, dtype, this.registry);
    }

    private void initSingleOpExpression(FilterOpFullExp fullexp, DStructType dtype) {
        boolean reversed;
        String fieldOrVarOrFn;
        FilterOpExp foexp = (FilterOpExp)fullexp.opexp1;
        Exp xop1 = foexp.getFirstArg();
        Exp xop2 = foexp.getSecondArg();
        DType op1HintType = null;
        DType op2HintType = null;
        if (xop1 instanceof IdentExp) {
            fieldOrVarOrFn = ((IdentExp)xop1).strValue();
            op1HintType = DValueHelper.findFieldType(dtype, fieldOrVarOrFn);
        }
        if (xop2 instanceof IdentExp) {
            fieldOrVarOrFn = ((IdentExp)xop2).strValue();
            op2HintType = DValueHelper.findFieldType(dtype, fieldOrVarOrFn);
        }
        OpFactory factory = new OpFactory(this.registry);
        this.evaluator = factory.create(foexp.op, xop1, xop2, op1HintType, op2HintType, fullexp.negFlag);
        boolean bl = reversed = xop2 instanceof IdentExp || xop2 instanceof XNAFMultiExp;
        if (reversed) {
            this.evaluator.setRightVar(xop1);
        } else {
            this.evaluator.setRightVar(xop2);
        }
    }

    private void initSingleInExpression(FilterOpFullExp fullexp, DStructType dtype) {
        this.evaluator = new InEvaluator(fullexp, dtype);
    }

    @Override
    public List<DValue> match(List<DValue> list) {
        ArrayList<DValue> resultL = new ArrayList<DValue>();
        for (DValue dval : list) {
            boolean b = this.evaluator.match(dval);
            if (!b) continue;
            resultL.add(dval);
        }
        return resultL;
    }
}

