/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.memdb;

import org.delia.db.DBAccessContext;
import org.delia.db.DBExecutor;
import org.delia.db.DBInterface;
import org.delia.db.InsertContext;
import org.delia.db.QueryContext;
import org.delia.db.QuerySpec;
import org.delia.db.memdb.MemDBInterface;
import org.delia.runner.QueryResponse;
import org.delia.type.DValue;

public class MemDBExecutor
implements DBExecutor {
    private DBInterface dbInterface;
    private DBAccessContext dbctx;

    public MemDBExecutor(MemDBInterface memDBInterface, DBAccessContext ctx) {
        this.dbInterface = memDBInterface;
        this.dbctx = ctx;
    }

    public void forceDBInterface(DBInterface newOne) {
        this.dbInterface = newOne;
    }

    @Override
    public DValue executeInsert(DValue dval, InsertContext ctx) {
        return this.dbInterface.executeInsert(dval, ctx, this.dbctx);
    }

    @Override
    public int executeUpdate(QuerySpec spec, DValue dvalPartial) {
        return this.dbInterface.executeUpdate(spec, dvalPartial, this.dbctx);
    }

    @Override
    public QueryResponse executeQuery(QuerySpec spec, QueryContext qtx) {
        return this.dbInterface.executeQuery(spec, qtx, this.dbctx);
    }

    @Override
    public void executeDelete(QuerySpec spec) {
        this.dbInterface.executeDelete(spec, this.dbctx);
    }

    @Override
    public boolean execTableDetect(String tableName) {
        return this.dbInterface.doesTableExist(tableName, this.dbctx);
    }

    @Override
    public void close() {
    }

    @Override
    public void createTable(String tableName) {
        this.dbInterface.createTable(tableName, this.dbctx);
    }

    @Override
    public void deleteTable(String tableName) {
        this.dbInterface.deleteTable(tableName, this.dbctx);
    }

    @Override
    public void renameTable(String tableName, String newTableName) {
        this.dbInterface.renameTable(tableName, newTableName, this.dbctx);
    }

    @Override
    public void createField(String typeName, String field) {
        this.dbInterface.createField(typeName, field, this.dbctx);
    }

    @Override
    public void deleteField(String typeName, String field) {
        this.dbInterface.deleteField(typeName, field, this.dbctx);
    }

    @Override
    public boolean execFieldDetect(String tableName, String fieldName) {
        return this.dbInterface.doesFieldExist(tableName, fieldName, this.dbctx);
    }

    @Override
    public void renameField(String typeName, String field, String newName) {
        this.dbInterface.renameField(typeName, field, newName, this.dbctx);
    }

    @Override
    public void alterFieldType(String typeName, String fieldName, String newFieldType) {
        this.dbInterface.alterFieldType(typeName, fieldName, newFieldType, this.dbctx);
    }

    @Override
    public void alterField(String typeName, String fieldName, String deltaFlags) {
        this.dbInterface.alterField(typeName, fieldName, deltaFlags, this.dbctx);
    }
}

