/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.h2.test;

import org.delia.core.FactoryService;
import org.delia.db.DBAccessContext;
import org.delia.db.DBExecutor;
import org.delia.db.DBInterface;
import org.delia.log.Log;

public class H2TestCleaner {
    public void deleteKnownTables(FactoryService factorySvc, DBInterface innerInterface) {
        DBExecutor executor = innerInterface.createExector(new DBAccessContext(null, null));
        boolean b = innerInterface.isSQLLoggingEnabled();
        innerInterface.enableSQLLogging(false);
        this.safeDeleteTable(executor, "cars;");
        this.safeDeleteTable(executor, "ADDRESS;");
        this.safeDeleteTable(executor, "Customer;");
        this.safeDeleteTable(executor, "CUSTOMER;");
        this.safeDeleteTable(executor, "CUSTOMERS;");
        this.safeDeleteTable(executor, "CustomerAddressAssoc;");
        this.safeDeleteTable(executor, "AddressCustomerAssoc;");
        this.safeDeleteTable(executor, "Address;");
        this.safeDeleteTable(executor, "Customer;");
        this.safeDeleteTable(executor, "Customer__BAK;");
        this.safeDeleteTable(executor, "Actor;");
        this.safeDeleteTable(executor, "Flight;");
        this.safeDeleteTable(executor, "Flight2;");
        this.safeDeleteTable(executor, "BASE;");
        this.safeDeleteTable(executor, "BASE2;");
        String tbl = "DELIA_SCHEMA_VERSION";
        this.safeDeleteTable(executor, tbl.toLowerCase());
        executor.close();
        innerInterface.enableSQLLogging(b);
    }

    public void deleteTables(FactoryService factorySvc, DBInterface innerInterface, String tables) {
        String[] ar;
        DBExecutor executor = innerInterface.createExector(new DBAccessContext(null, null));
        boolean b = innerInterface.isSQLLoggingEnabled();
        innerInterface.enableSQLLogging(false);
        Log log = factorySvc.getLog();
        log.log("--delete TABLES -- ", new Object[0]);
        for (String tbl : ar = tables.split(",")) {
            log.log("delete table: %s", tbl);
            this.safeDeleteTable(executor, tbl);
        }
    }

    public void safeDeleteTable(DBExecutor executor, String tblName) {
        try {
            executor.deleteTable(tblName);
        }
        catch (Exception e) {
            System.out.print(e.getMessage());
        }
    }
}

