/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db.h2;

import org.delia.db.DBAccessContext;
import org.delia.db.DBExecutor;
import org.delia.db.InsertContext;
import org.delia.db.QueryContext;
import org.delia.db.QuerySpec;
import org.delia.db.h2.H2DBConnection;
import org.delia.db.h2.H2DBInterface;
import org.delia.runner.QueryResponse;
import org.delia.type.DValue;

public class H2DBExecutor
implements DBExecutor {
    private H2DBInterface dbInterface;
    private DBAccessContext dbctx;

    public H2DBExecutor(H2DBInterface dbInterface, DBAccessContext ctx, H2DBConnection conn) {
        this.dbInterface = dbInterface;
        this.dbctx = ctx;
        this.dbctx.connObject = conn;
    }

    public H2DBConnection getConn() {
        return (H2DBConnection)this.dbctx.connObject;
    }

    @Override
    public DValue executeInsert(DValue dval, InsertContext ctx) {
        return this.dbInterface.executeInsert(dval, ctx, this.dbctx);
    }

    @Override
    public int executeUpdate(QuerySpec spec, DValue dvalPartial) {
        return this.dbInterface.executeUpdate(spec, dvalPartial, this.dbctx);
    }

    @Override
    public QueryResponse executeQuery(QuerySpec spec, QueryContext qtx) {
        return this.dbInterface.executeQuery(spec, qtx, this.dbctx);
    }

    @Override
    public void executeDelete(QuerySpec spec) {
        this.dbInterface.executeDelete(spec, this.dbctx);
    }

    @Override
    public boolean execTableDetect(String tableName) {
        DBAccessContext tmp = this.dbctx.clone();
        tmp.disableSqlLogging = true;
        return this.dbInterface.doesTableExist(tableName.toUpperCase(), tmp);
    }

    @Override
    public void close() {
        H2DBConnection conn = (H2DBConnection)this.dbctx.connObject;
        conn.close();
    }

    @Override
    public void createTable(String tableName) {
        this.dbInterface.createTable(tableName, this.dbctx);
    }

    @Override
    public void deleteTable(String tableName) {
        this.dbInterface.deleteTable(tableName, this.dbctx);
    }

    @Override
    public void renameTable(String tableName, String newTableName) {
        this.dbInterface.renameTable(tableName, newTableName, this.dbctx);
    }

    @Override
    public void createField(String typeName, String field) {
        this.dbInterface.createField(typeName, field, this.dbctx);
    }

    @Override
    public void deleteField(String typeName, String field) {
        this.dbInterface.deleteField(typeName, field, this.dbctx);
    }

    @Override
    public boolean execFieldDetect(String tableName, String fieldName) {
        return this.dbInterface.doesFieldExist(tableName, fieldName, this.dbctx);
    }

    @Override
    public void renameField(String typeName, String fieldName, String newName) {
        this.dbInterface.renameField(typeName, fieldName, newName, this.dbctx);
    }

    @Override
    public void alterFieldType(String typeName, String fieldName, String newFieldType) {
        this.dbInterface.alterFieldType(typeName, fieldName, newFieldType, this.dbctx);
    }

    @Override
    public void alterField(String typeName, String fieldName, String deltaFlags) {
        this.dbInterface.alterField(typeName, fieldName, deltaFlags, this.dbctx);
    }
}

