/*
 * Decompiled with CFR 0.152.
 */
package org.delia.db;

import org.delia.core.FactoryService;
import org.delia.db.DBAccessContext;
import org.delia.db.DBCapabilties;
import org.delia.db.DBExecutor;
import org.delia.db.DBInterface;
import org.delia.db.DBType;
import org.delia.db.InsertContext;
import org.delia.db.QueryContext;
import org.delia.db.QuerySpec;
import org.delia.db.memdb.MemDBExecutor;
import org.delia.db.memdb.MemDBInterface;
import org.delia.runner.QueryResponse;
import org.delia.type.DValue;

public class InstrumentedDBInterface
implements DBInterface {
    public DBInterface actualInterface;
    public int insertCount;
    public int updateCount;
    public int deleteCount;
    public int queryCount;

    public InstrumentedDBInterface(DBInterface actual) {
        this.actualInterface = actual;
    }

    @Override
    public DBCapabilties getCapabilities() {
        return this.actualInterface.getCapabilities();
    }

    @Override
    public void init(FactoryService factorySvc) {
        this.actualInterface.init(factorySvc);
    }

    @Override
    public DValue executeInsert(DValue dval, InsertContext ctx, DBAccessContext dbctx) {
        ++this.insertCount;
        return this.actualInterface.executeInsert(dval, ctx, dbctx);
    }

    @Override
    public int executeUpdate(QuerySpec spec, DValue dvalPartial, DBAccessContext dbctx) {
        ++this.updateCount;
        return this.actualInterface.executeUpdate(spec, dvalPartial, dbctx);
    }

    @Override
    public QueryResponse executeQuery(QuerySpec spec, QueryContext qtx, DBAccessContext dbctx) {
        ++this.queryCount;
        return this.actualInterface.executeQuery(spec, qtx, dbctx);
    }

    @Override
    public void executeDelete(QuerySpec spec, DBAccessContext dbctx) {
        ++this.deleteCount;
        this.actualInterface.executeDelete(spec, dbctx);
    }

    @Override
    public boolean doesTableExist(String tableName, DBAccessContext dbctx) {
        return this.actualInterface.doesTableExist(tableName, dbctx);
    }

    @Override
    public void createTable(String tableName, DBAccessContext dbctx) {
        this.actualInterface.createTable(tableName, dbctx);
    }

    @Override
    public void deleteTable(String tableName, DBAccessContext dbctx) {
        this.actualInterface.deleteTable(tableName, dbctx);
    }

    @Override
    public void renameTable(String tableName, String newTableName, DBAccessContext dbctx) {
        this.actualInterface.renameTable(tableName, newTableName, dbctx);
    }

    @Override
    public boolean isSQLLoggingEnabled() {
        return this.actualInterface.isSQLLoggingEnabled();
    }

    @Override
    public void enableSQLLogging(boolean b) {
        this.actualInterface.enableSQLLogging(b);
    }

    @Override
    public void createField(String typeName, String field, DBAccessContext dbctx) {
        this.actualInterface.createField(typeName, field, dbctx);
    }

    @Override
    public void deleteField(String typeName, String field, DBAccessContext dbctx) {
        this.actualInterface.deleteField(typeName, field, dbctx);
    }

    @Override
    public DBExecutor createExector(DBAccessContext ctx) {
        DBExecutor executor = this.actualInterface.createExector(ctx);
        if (this.actualInterface instanceof MemDBInterface) {
            MemDBExecutor memexecutor = (MemDBExecutor)executor;
            memexecutor.forceDBInterface(this);
        }
        return executor;
    }

    @Override
    public DBType getDBType() {
        return this.actualInterface.getDBType();
    }

    @Override
    public boolean doesFieldExist(String tableName, String fieldName, DBAccessContext dbctx) {
        return this.actualInterface.doesFieldExist(tableName, fieldName, dbctx);
    }

    @Override
    public void renameField(String typeName, String fieldName, String newName, DBAccessContext dbctx) {
        this.actualInterface.renameField(typeName, fieldName, newName, dbctx);
    }

    @Override
    public void alterFieldType(String typeName, String fieldName, String newFieldType, DBAccessContext dbctx) {
        this.actualInterface.alterFieldType(typeName, fieldName, newFieldType, dbctx);
    }

    @Override
    public void alterField(String typeName, String fieldName, String deltaFlags, DBAccessContext dbctx) {
        this.actualInterface.alterField(typeName, fieldName, deltaFlags, dbctx);
    }
}

