/*
 * Decompiled with CFR 0.152.
 */
package org.delia.core;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.delia.core.DateFormatService;
import org.delia.core.DateFormatter;
import org.delia.core.TimeZoneService;
import org.delia.error.DeliaError;
import org.delia.runner.DeliaException;

public class DateFormatServiceImpl
implements DateFormatService {
    private final DateFormat df1 = new SimpleDateFormat("yyyy");
    private final DateFormat df2 = new SimpleDateFormat("yyyy-MM");
    private final DateFormat df3 = new SimpleDateFormat("yyyy-MM-dd");
    private final DateFormat df4 = new SimpleDateFormat("yyyy-MM-dd'T'HH");
    private final DateFormat df5 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
    private final DateFormat df6 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final DateFormat df6a = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private final DateFormat df7 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final DateFormat dfFull = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private TimeZoneService tzSvc;

    public DateFormatServiceImpl(TimeZoneService tzSvc) {
        this.tzSvc = tzSvc;
    }

    @Override
    public Date parse(String input) {
        Date dt = null;
        try {
            DateFormat df = this.getDateFormat(input);
            this.applyTimeZone(df);
            dt = df.parse(input);
        }
        catch (ParseException e) {
            DeliaError err = new DeliaError("date-parse-error", e.getMessage(), null);
            throw new DeliaException(err);
        }
        return dt;
    }

    private void applyTimeZone(DateFormat df) {
        TimeZone tz = this.tzSvc.getDefaultTimeZone();
        df.setTimeZone(tz);
    }

    @Override
    public String format(Date dt) {
        this.applyTimeZone(this.dfFull);
        return this.dfFull.format(dt);
    }

    private DateFormat getDateFormat(String input) {
        int len = input.length();
        switch (len) {
            case 4: {
                return this.df1;
            }
            case 7: {
                return this.df2;
            }
            case 10: {
                return this.df3;
            }
            case 13: {
                return this.df4;
            }
            case 16: {
                return this.df5;
            }
            case 19: {
                return this.df6;
            }
            case 23: {
                return this.df6;
            }
            case 24: {
                return this.df6a;
            }
        }
        return this.dfFull;
    }

    @Override
    public TimeZone detectTimezone(String input) {
        int n = input.length();
        if (n < 5) {
            return this.tzSvc.getDefaultTimeZone();
        }
        int index = input.lastIndexOf(45);
        if (index == n - 5) {
            String s = input.substring(index);
            String ss = String.format("GMT%s", s);
            TimeZone tz2 = TimeZone.getTimeZone(ss);
            return tz2;
        }
        return this.tzSvc.getDefaultTimeZone();
    }

    @Override
    public DateFormatter createFormatter(String input) {
        TimeZone tz = this.detectTimezone(input);
        return new DateFormatter(tz, this.dfFull);
    }

    @Override
    public DateFormatter createFormatter() {
        TimeZone tz = this.tzSvc.getDefaultTimeZone();
        return new DateFormatter(tz, this.dfFull);
    }
}

