/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler.ast;

import java.util.List;
import java.util.StringJoiner;
import org.delia.compiler.ast.ExpBase;
import org.delia.compiler.ast.IdentExp;
import org.delia.compiler.ast.UserFuncHeaderExp;
import org.delia.compiler.ast.UserFunctionBodyExp;

public class UserFunctionDefStatementExp
extends ExpBase {
    public String funcName;
    public UserFunctionBodyExp bodyExp;
    public List<IdentExp> argsL;

    public UserFunctionDefStatementExp(int pos, UserFuncHeaderExp hdrExp, UserFunctionBodyExp body) {
        super(pos);
        this.funcName = hdrExp.fnName;
        this.argsL = hdrExp.argsL;
        this.bodyExp = body;
    }

    @Override
    public String strValue() {
        String ss = String.format("function %s(", this.funcName);
        StringJoiner joiner = new StringJoiner(",");
        for (IdentExp exp : this.argsL) {
            joiner.add(exp.name());
        }
        ss = ss + String.format("%s){", joiner.toString());
        ss = ss + this.bodyExp.strValue();
        ss = String.format("%s}", ss);
        return ss;
    }

    public String toString() {
        String ss = String.format("function %s(", this.funcName);
        StringJoiner joiner = new StringJoiner(",");
        for (IdentExp exp : this.argsL) {
            joiner.add(exp.name());
        }
        ss = ss + String.format("%s){", joiner.toString());
        ss = ss + this.bodyExp.toString();
        ss = String.format("%s}", ss);
        return ss;
    }
}

