/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler.ast;

import org.delia.compiler.ast.ExpBase;
import org.delia.compiler.ast.FieldQualifierExp;
import org.delia.compiler.ast.StructFieldPrefix;

public class StructFieldExp
extends ExpBase {
    public String fieldName;
    public String typeName;
    public boolean isOptional;
    public boolean isPrimaryKey;
    public boolean isUnique;
    public boolean isRelation;
    public boolean isOne;
    public boolean isMany;
    public boolean isParent;
    public boolean isSerial;

    public StructFieldExp(StructFieldPrefix structFieldPrefix, FieldQualifierExp qual1, FieldQualifierExp qual2, FieldQualifierExp qual3, FieldQualifierExp qual4) {
        super(structFieldPrefix.pos);
        this.fieldName = structFieldPrefix.nameExp.name();
        this.typeName = structFieldPrefix.exp.name();
        this.isRelation = structFieldPrefix.isRelation;
        if (qual1 != null) {
            this.setFlags(qual1);
        }
        if (qual2 != null) {
            this.setFlags(qual2);
        }
        if (qual3 != null) {
            this.setFlags(qual3);
        }
        if (qual4 != null) {
            this.setFlags(qual4);
        }
    }

    private void setFlags(FieldQualifierExp qual) {
        if (qual.strValue().equals("optional")) {
            this.isOptional = true;
        } else if (qual.strValue().equals("unique")) {
            this.isUnique = true;
        } else if (qual.strValue().equals("one")) {
            this.isOne = true;
        } else if (qual.strValue().equals("many")) {
            this.isMany = true;
        } else if (qual.strValue().equals("primaryKey")) {
            this.isPrimaryKey = true;
        } else if (qual.strValue().equals("parent")) {
            this.isParent = true;
        } else if (qual.strValue().equals("serial")) {
            this.isSerial = true;
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String strValue() {
        String srel = this.isRelation ? "relation " : "";
        String ss = String.format("%s%s %s", srel, this.fieldName, this.typeName);
        if (this.isOptional) {
            ss = ss + " optional";
        }
        if (this.isPrimaryKey) {
            ss = ss + " primaryKey";
        }
        if (this.isUnique) {
            ss = ss + " unique";
        }
        if (this.isOne) {
            ss = ss + " one";
        }
        if (this.isMany) {
            ss = ss + " many";
        }
        if (this.isParent) {
            ss = ss + " parent";
        }
        if (this.isSerial) {
            ss = ss + " serial";
        }
        return ss;
    }

    public String toString() {
        return this.strValue();
    }
}

