/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler.ast;

import java.util.ArrayList;
import java.util.List;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.ExpBase;
import org.delia.compiler.ast.IdentExp;

public class QueryFuncExp
extends ExpBase {
    public String funcName;
    public List<Exp> argL = new ArrayList<Exp>();
    public boolean isRuleFn;

    public QueryFuncExp(int pos, IdentExp nameExp, List<List<Exp>> args, boolean isRuleFn) {
        super(pos);
        this.funcName = nameExp.name();
        this.isRuleFn = isRuleFn;
        if (args != null) {
            ArrayList<Exp> list = new ArrayList<Exp>();
            if (!args.isEmpty()) {
                for (List<Exp> sublist : args) {
                    for (Exp inner : sublist) {
                        list.add(inner);
                    }
                }
            }
            this.argL = list;
        }
    }

    @Override
    public String strValue() {
        String ss = String.format("%s(", this.funcName);
        int i = 0;
        for (Exp exp : this.argL) {
            ss = i > 0 ? ss + "," + exp.strValue() : ss + exp.strValue();
            ++i;
        }
        ss = String.format("%s)", ss);
        return ss;
    }

    public String toString() {
        String ss = String.format("%s%s(", this.isRuleFn ? "" : ".", this.funcName);
        int i = 0;
        for (Exp exp : this.argL) {
            ss = i > 0 ? ss + "," + this.formatValue(exp) : ss + this.formatValue(exp);
            ++i;
        }
        ss = String.format("%s)", ss);
        return ss;
    }
}

