/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler.ast;

import org.delia.compiler.ast.BooleanExp;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.ExpBase;
import org.delia.compiler.ast.IdentExp;
import org.delia.compiler.ast.IntegerExp;
import org.delia.compiler.ast.LongExp;
import org.delia.compiler.ast.NumberExp;
import org.delia.compiler.ast.QueryExp;
import org.delia.compiler.ast.StringExp;
import org.delia.compiler.ast.UserFnCallExp;

public class LetStatementExp
extends ExpBase {
    public static final String QUERY_RESPONSE_TYPE = "queryResponse";
    public static final String USER_FUNC_TYPE = "userFunc";
    public String varName;
    public String typeName;
    public boolean isTypeExplicit;
    public Exp value;

    public LetStatementExp(int pos, IdentExp varname, IdentExp typeName, Exp val) {
        super(pos);
        this.varName = varname.name();
        this.value = val;
        if (typeName == null) {
            this.autosetType();
            this.isTypeExplicit = false;
        } else {
            this.typeName = typeName.name();
            this.isTypeExplicit = true;
        }
    }

    public boolean isType(String typeName2) {
        return this.typeName != null && this.typeName.equals(typeName2);
    }

    private void autosetType() {
        if (this.value instanceof LongExp) {
            this.typeName = "long";
        } else if (this.value instanceof IntegerExp) {
            this.typeName = "int";
        } else if (this.value instanceof NumberExp) {
            this.typeName = "number";
        } else if (this.value instanceof StringExp) {
            this.typeName = "string";
        } else if (this.value instanceof BooleanExp) {
            this.typeName = "boolean";
        } else if (this.value instanceof QueryExp) {
            this.typeName = QUERY_RESPONSE_TYPE;
        } else if (this.value instanceof UserFnCallExp) {
            this.typeName = USER_FUNC_TYPE;
        }
    }

    @Override
    public String strValue() {
        return this.varName;
    }

    public String toString() {
        String s = "";
        s = this.value instanceof QueryExp ? this.value.toString() : (this.value == null ? "" : this.formatValue(this.value));
        String s2 = this.isTypeExplicit ? String.format(" %s", this.typeName) : "";
        return "let " + this.varName + s2 + " = " + s;
    }
}

