/*
 * Decompiled with CFR 0.152.
 */
package org.delia.compiler;

import java.util.List;
import org.delia.compiler.CompilerPassBase;
import org.delia.compiler.CompilerResults;
import org.delia.compiler.ErrorLineFinder;
import org.delia.compiler.ast.ConfigureStatementExp;
import org.delia.compiler.ast.Exp;
import org.delia.compiler.ast.ExpBase;
import org.delia.compiler.ast.FilterOpExp;
import org.delia.compiler.ast.LetStatementExp;
import org.delia.compiler.ast.QueryExp;
import org.delia.compiler.ast.StructFieldExp;
import org.delia.compiler.ast.TypeStatementExp;
import org.delia.core.ConfigureService;
import org.delia.core.FactoryService;
import org.delia.db.memdb.filter.OP;
import org.delia.error.DeliaError;
import org.delia.runner.InternalCompileState;
import org.delia.type.BuiltInTypes;

public class Pass2Compiler
extends CompilerPassBase {
    public Pass2Compiler(FactoryService factorySvc, ErrorLineFinder errorLineFinder, InternalCompileState execCtx) {
        super(factorySvc, errorLineFinder, execCtx);
    }

    @Override
    public CompilerResults process(List<Exp> list) {
        CompilerResults results = new CompilerResults();
        results.list = list;
        for (Exp exp : list) {
            ExpBase typeExp;
            if (exp instanceof LetStatementExp) {
                LetStatementExp letExp = (LetStatementExp)exp;
                this.checkLetStatement(results, letExp);
                continue;
            }
            if (exp instanceof TypeStatementExp) {
                typeExp = (TypeStatementExp)exp;
                this.checkTypeStatement(results, (TypeStatementExp)typeExp);
                continue;
            }
            if (!(exp instanceof ConfigureStatementExp)) continue;
            typeExp = (ConfigureStatementExp)exp;
            this.checkConfigureStatement(results, (ConfigureStatementExp)typeExp);
        }
        return results;
    }

    private void checkConfigureStatement(CompilerResults results, ConfigureStatementExp configExp) {
        this.log.log("config " + configExp.strValue(), new Object[0]);
        ConfigureService configSvc = this.factorySvc.getConfigureService();
        boolean b = configSvc.validate(configExp.varName);
        if (!b) {
            String msg = String.format("configure: unknown variable '%s'", configExp.varName);
            this.addError(results, "configure-unknown-var", msg, configExp);
        }
    }

    private void checkTypeStatement(CompilerResults results, TypeStatementExp typeExp) {
        this.checkTypeName(typeExp, results);
        if (typeExp.structExp != null) {
            for (StructFieldExp sfe : typeExp.structExp.argL) {
                String msg;
                this.checkModifiers(sfe, results);
                if (this.isScalar(sfe)) {
                    if (sfe.isRelation) {
                        msg = String.format("relation cannot be used with scalar types - field '%s'", sfe.fieldName);
                        this.addError(results, "relation-wrong-type", msg, sfe);
                        continue;
                    }
                    if (sfe.isMany) {
                        msg = String.format("'many' can only be used with relations - field '%s'", sfe.fieldName);
                        this.addError(results, "many-error", msg, sfe);
                        continue;
                    }
                    if (!sfe.isOne) continue;
                    msg = String.format("'one' can only be used with relations - field '%s'", sfe.fieldName);
                    this.addError(results, "many-error", msg, sfe);
                    continue;
                }
                if (sfe.isMany && sfe.isOne) {
                    msg = String.format("cannot use 'one' and 'many' on same field - field '%s'", sfe.fieldName);
                    this.addError(results, "one-and-many-error", msg, sfe);
                }
                if (!sfe.isSerial) continue;
                msg = String.format("cannot use 'serial' on relation fields - field '%s'", sfe.fieldName);
                this.addError(results, "serial-error", msg, sfe);
            }
        }
    }

    private void checkTypeName(TypeStatementExp typeExp, CompilerResults results) {
        if (BuiltInTypes.isBuiltInScalarType(typeExp.typeName)) {
            String msg = String.format("Type name already used - type'%s'", typeExp.typeName);
            this.addError(results, "typename.in.use", msg, typeExp);
        }
    }

    private void checkModifiers(StructFieldExp qfe, CompilerResults results) {
        String msg;
        if (qfe.isOptional && qfe.isPrimaryKey) {
            msg = String.format("optional and primaryKey cannot be used together - field '%s'", qfe.fieldName);
            this.addError(results, "optional-primarykey-not-allowed", msg, qfe);
        }
        if (qfe.isOptional && qfe.isSerial) {
            msg = String.format("optional and serial cannot be used together - field '%s'", qfe.fieldName);
            this.addError(results, "optional-serial-not-allowed", msg, qfe);
        }
        if (qfe.isUnique && qfe.isPrimaryKey) {
            msg = String.format("unique and primaryKey cannot be used together - field '%s'", qfe.fieldName);
            this.addError(results, "unique-primarykey-not-allowed", msg, qfe);
        }
    }

    private void addError(CompilerResults results, String id, String msg, Exp exp) {
        DeliaError err = this.createError(id, msg, exp);
        results.errors.add(err);
    }

    private boolean isScalar(StructFieldExp qfe) {
        return BuiltInTypes.isBuiltInScalarType(qfe.typeName);
    }

    private boolean findField(String target, TypeStatementExp typeExp) {
        for (StructFieldExp fieldExp : typeExp.structExp.argL) {
            if (!fieldExp.getFieldName().equals(target)) continue;
            return true;
        }
        return false;
    }

    private void checkLetStatement(CompilerResults results, LetStatementExp letExp) {
        if (letExp.value instanceof QueryExp) {
            QueryExp qexp = (QueryExp)letExp.value;
            if (qexp.filter != null && qexp.filter.cond instanceof FilterOpExp) {
                FilterOpExp fexp = (FilterOpExp)qexp.filter.cond;
                OP op = OP.createFromString(fexp.op);
                if (op != null) {
                    // empty if block
                }
            }
        }
    }
}

