/*
 * Decompiled with CFR 0.152.
 */
package org.delia.builder;

import org.delia.builder.ConnectionInfo;
import org.delia.db.DBType;
import org.delia.db.sql.ConnectionString;

public class ConnectionBuilder {
    private static ConnectionBuilder theSingleton;
    private String jdbcUrl;
    private DBType dbType;
    private String userName;
    private String password;

    public static ConnectionBuilder dbType(DBType dbType) {
        theSingleton = new ConnectionBuilder();
        ConnectionBuilder.theSingleton.dbType = dbType;
        return theSingleton;
    }

    public ConnectionBuilder jdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public ConnectionBuilder userName(String userName) {
        this.userName = userName;
        return this;
    }

    public ConnectionBuilder password(String password) {
        this.password = password;
        return this;
    }

    public ConnectionBuilder connectionString(ConnectionString connStr) {
        this.jdbcUrl = connStr.jdbcUrl;
        this.userName = connStr.userName;
        this.password = connStr.pwd;
        return this;
    }

    public ConnectionInfo build() {
        ConnectionInfo info = new ConnectionInfo();
        info.dbType = this.dbType;
        info.jdbcUrl = this.jdbcUrl;
        info.password = this.password;
        info.userName = this.userName;
        return info;
    }
}

