/*
 * Decompiled with CFR 0.152.
 */
package org.delia.api;

import org.delia.api.Delia;
import org.delia.api.DeliaImpl;
import org.delia.builder.ConnectionInfo;
import org.delia.core.FactoryService;
import org.delia.db.DBInterface;
import org.delia.db.DBInterfaceInternal;
import org.delia.db.DBType;
import org.delia.db.h2.H2DBInterface;
import org.delia.db.memdb.MemDBInterface;
import org.delia.db.postgres.PostgresDBInterface;
import org.delia.db.sql.ConnectionFactoryImpl;
import org.delia.db.sql.ConnectionString;
import org.delia.log.Log;
import org.delia.util.DeliaExceptionHelper;

public class DeliaFactory {
    public static Delia create(ConnectionInfo info, Log log, FactoryService factorySvc) {
        ConnectionString connectionString = new ConnectionString();
        connectionString.jdbcUrl = info.jdbcUrl;
        connectionString.pwd = info.password;
        connectionString.userName = info.userName;
        return DeliaFactory.create(connectionString, info.dbType, log, factorySvc);
    }

    public static Delia create(ConnectionString connectionString, DBType dbType, Log log, FactoryService factorySvc) {
        ConnectionFactoryImpl connFactory = new ConnectionFactoryImpl(connectionString, log);
        DBInterfaceInternal dbInterface = null;
        switch (dbType) {
            case MEM: {
                dbInterface = new MemDBInterface();
                dbInterface.createTablesAsNeededFlag = true;
                break;
            }
            case H2: {
                dbInterface = new H2DBInterface(factorySvc, connFactory);
                break;
            }
            case POSTGRES: {
                dbInterface = new PostgresDBInterface(factorySvc, connFactory);
                break;
            }
            default: {
                DeliaExceptionHelper.throwError("unsupported-db-type", "Unknown DBType %s.", dbType == null ? "null" : dbType.name());
            }
        }
        return DeliaFactory.create(dbInterface, log, factorySvc);
    }

    public static Delia create(DBInterface dbInterface, Log log, FactoryService factorySvc) {
        return new DeliaImpl(dbInterface, log, factorySvc);
    }
}

