/*
 * Decompiled with CFR 0.152.
 */
package org.defendev.common.spring6.security;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.defendev.common.spring6.security.QuasiLoginAuthenticationException;
import org.defendev.common.spring6.security.QuasiLoginAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;

public class QuasiLoginAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger log = LogManager.getLogger();

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.isInstanceOf(QuasiLoginAuthenticationToken.class, (Object)authentication, () -> "QuasiLoginAuthenticationProvider only supports QuasiLoginAuthenticationToken");
        QuasiLoginAuthenticationToken token = (QuasiLoginAuthenticationToken)authentication;
        if (Objects.isNull(token.getPrincipal()) || StringUtils.isBlank((CharSequence)token.getName())) {
            throw new QuasiLoginAuthenticationException("Something went wrong during QuasiLogin authentication");
        }
        return token.authenticated();
    }

    public boolean supports(Class<?> authentication) {
        return QuasiLoginAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

