/*
 * Decompiled with CFR 0.152.
 */
package org.defendev.common.spring6.security;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.defendev.common.spring6.security.QuasiLoginAuthenticationException;
import org.defendev.common.spring6.security.QuasiLoginAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class QuasiLoginAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger log = LogManager.getLogger();

    public QuasiLoginAuthenticationFilter(String defaultFilterProcessesUrl, AuthenticationManager authenticationManager) {
        super(defaultFilterProcessesUrl, authenticationManager);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        String requestMethod = request.getMethod();
        if (!requestMethod.equals("POST")) {
            throw new QuasiLoginAuthenticationException("Authentication not supported for HTTP method: " + requestMethod);
        }
        String quasiUsername = request.getParameter("quasiUsername");
        String quasiFullName = request.getParameter("quasiFullName");
        UserDetails quasiUser = User.builder().username(quasiUsername).password("quasi").accountExpired(false).accountLocked(false).authorities(List.of()).build();
        QuasiLoginAuthenticationToken token = new QuasiLoginAuthenticationToken(quasiUser, List.of(), false);
        return this.getAuthenticationManager().authenticate((Authentication)token);
    }
}

