/*
 * Decompiled with CFR 0.152.
 */
package org.defendev.common.spring6.data.jpa.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.defendev.common.domain.query.Query;
import org.defendev.common.domain.query.sort.SortDirection;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.JpaSort;

public abstract class PageableSpecification<T extends Query> {
    public static final Map<SortDirection, Sort.Direction> TO_SPRINGDATA_DIRECTION = Map.of(SortDirection.asc, Sort.Direction.ASC, SortDirection.desc, Sort.Direction.DESC);
    protected final T query;

    public PageableSpecification(T query) {
        this.query = query;
    }

    public abstract JpaSort getDefaultSort();

    public abstract Pageable toPageable();

    public Sort conjunctWithDefaultSort(List<JpaSort> sorts) {
        ArrayList<JpaSort> sortsWithDefault = new ArrayList<JpaSort>(Objects.isNull(sorts) ? List.of() : sorts);
        sortsWithDefault.add(this.getDefaultSort());
        Sort result = (Sort)sortsWithDefault.get(0);
        for (int i = 1; i < sortsWithDefault.size(); ++i) {
            result = result.and((Sort)sortsWithDefault.get(i));
        }
        return result;
    }
}

