/*
 * Decompiled with CFR 0.152.
 */
package org.defendev.common.spring6.core.convert;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.defendev.common.domain.exception.QueryFailedException;
import org.defendev.common.domain.query.result.QueryResult;
import org.defendev.common.domain.query.sort.SortDirection;
import org.defendev.common.domain.query.sort.SortOrder;
import org.springframework.core.convert.converter.Converter;

public class SortOrdersQueryParamConverter
implements Converter<String, List<SortOrder>> {
    public List<SortOrder> convert(String source) {
        String[] orderStrings = StringUtils.split((String)source, (String)",");
        if (Objects.isNull(orderStrings)) {
            return List.of();
        }
        return Stream.of(orderStrings).map(orderString -> {
            String[] propertyAndDirection = StringUtils.split((String)orderString, (String)":", (int)2);
            if (Objects.isNull(propertyAndDirection) || 2 != propertyAndDirection.length) {
                throw new QueryFailedException(new QueryResult(QueryResult.Status.REQUEST_INVALID, "Invalid sort specified", null, null));
            }
            return new SortOrder(SortDirection.valueOf((String)propertyAndDirection[1]), propertyAndDirection[0]);
        }).collect(Collectors.toList());
    }
}

