/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.gym;

public final class StepReply<OBSERVATION> {
    private final OBSERVATION observation;
    private final double reward;
    private final boolean done;
    private final Object info;

    public StepReply(OBSERVATION observation, double reward, boolean done, Object info) {
        this.observation = observation;
        this.reward = reward;
        this.done = done;
        this.info = info;
    }

    public OBSERVATION getObservation() {
        return this.observation;
    }

    public double getReward() {
        return this.reward;
    }

    public boolean isDone() {
        return this.done;
    }

    public Object getInfo() {
        return this.info;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StepReply)) {
            return false;
        }
        StepReply other = (StepReply)o;
        OBSERVATION this$observation = this.getObservation();
        OBSERVATION other$observation = other.getObservation();
        if (this$observation == null ? other$observation != null : !this$observation.equals(other$observation)) {
            return false;
        }
        if (Double.compare(this.getReward(), other.getReward()) != 0) {
            return false;
        }
        if (this.isDone() != other.isDone()) {
            return false;
        }
        Object this$info = this.getInfo();
        Object other$info = other.getInfo();
        return !(this$info == null ? other$info != null : !this$info.equals(other$info));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OBSERVATION $observation = this.getObservation();
        result = result * 59 + ($observation == null ? 43 : $observation.hashCode());
        long $reward = Double.doubleToLongBits(this.getReward());
        result = result * 59 + (int)($reward >>> 32 ^ $reward);
        result = result * 59 + (this.isDone() ? 79 : 97);
        Object $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        return result;
    }

    public String toString() {
        return "StepReply(observation=" + this.getObservation() + ", reward=" + this.getReward() + ", done=" + this.isDone() + ", info=" + this.getInfo() + ")";
    }
}

