/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import java.util.List;
import java.util.Map;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneOffset;
import oshi.hardware.common.AbstractFirmware;
import oshi.util.platform.windows.WmiUtil;

final class WindowsFirmware
extends AbstractFirmware {
    private static final long serialVersionUID = 1L;
    private static final WmiUtil.ValueType[] BIOS_TYPES = new WmiUtil.ValueType[]{WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.STRING, WmiUtil.ValueType.DATETIME};

    WindowsFirmware() {
        this.init();
    }

    private void init() {
        List<Object> releaseDate;
        List<Object> version;
        List<Object> descriptions;
        List<Object> names;
        Map<String, List<Object>> win32BIOS = WmiUtil.selectObjectsFrom(null, "Win32_BIOS", "Manufacturer,Name,Description,Version,ReleaseDate", "where PrimaryBIOS=true", BIOS_TYPES);
        List<Object> manufacturers = win32BIOS.get("Manufacturer");
        if (manufacturers != null && manufacturers.size() == 1) {
            this.setManufacturer((String)manufacturers.get(0));
        }
        if ((names = win32BIOS.get("Name")) != null && names.size() == 1) {
            this.setName((String)names.get(0));
        }
        if ((descriptions = win32BIOS.get("Description")) != null && descriptions.size() == 1) {
            this.setDescription((String)descriptions.get(0));
        }
        if ((version = win32BIOS.get("Version")) != null && version.size() == 1) {
            this.setVersion((String)version.get(0));
        }
        if ((releaseDate = win32BIOS.get("ReleaseDate")) != null && releaseDate.size() == 1) {
            this.setReleaseDate(Instant.ofEpochMilli((Long)releaseDate.get(0)).atZone(ZoneOffset.UTC).toLocalDate());
        }
    }
}

