/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.schedule;

import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class FixedSchedule
implements ISchedule {
    private final double value;

    public FixedSchedule(@JsonProperty(value="value") double value) {
        this.value = value;
    }

    @Override
    public double valueAt(int iteration, int epoch) {
        return this.value;
    }

    @Override
    public ISchedule clone() {
        return new FixedSchedule(this.value);
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedSchedule)) {
            return false;
        }
        FixedSchedule other = (FixedSchedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getValue(), other.getValue()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof FixedSchedule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        return result;
    }

    public String toString() {
        return "FixedSchedule(value=" + this.getValue() + ")";
    }
}

