/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer;

import java.nio.ByteBuffer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;

public class CudaUByteDataBuffer
extends BaseCudaDataBuffer {
    public CudaUByteDataBuffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
    }

    public CudaUByteDataBuffer(Pointer pointer, Pointer specialPointer, Indexer indexer, long length) {
        super(pointer, specialPointer, indexer, length);
    }

    public CudaUByteDataBuffer(ByteBuffer buffer, DataType dataType, long length, long offset) {
        super(buffer, dataType, length, offset);
    }

    public CudaUByteDataBuffer(long length) {
        super(length, 1);
    }

    public CudaUByteDataBuffer(long length, boolean initialize) {
        super(length, 1, initialize);
    }

    public CudaUByteDataBuffer(long length, int elementSize) {
        super(length, elementSize);
    }

    public CudaUByteDataBuffer(long length, int elementSize, long offset) {
        super(length, elementSize, offset);
    }

    public CudaUByteDataBuffer(long length, boolean initialize, MemoryWorkspace workspace) {
        super(length, 1, initialize, workspace);
    }

    public CudaUByteDataBuffer(float[] data, boolean copy, MemoryWorkspace workspace) {
        super(data, copy, 0L, workspace);
    }

    @Override
    protected void initTypeAndSize() {
        this.elementSize = 1;
        this.type = DataType.UBYTE;
    }

    public CudaUByteDataBuffer(DataBuffer underlyingBuffer, long length, long offset) {
        super(underlyingBuffer, length, offset);
    }

    public CudaUByteDataBuffer(float[] buffer) {
        super(buffer);
    }

    public CudaUByteDataBuffer(float[] data, boolean copy) {
        super(data, copy);
    }

    public CudaUByteDataBuffer(float[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaUByteDataBuffer(float[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        super(data, copy, offset, workspace);
    }

    public CudaUByteDataBuffer(double[] data) {
        super(data);
    }

    public CudaUByteDataBuffer(double[] data, boolean copy) {
        super(data, copy);
    }

    public CudaUByteDataBuffer(double[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    public CudaUByteDataBuffer(int[] data) {
        super(data);
    }

    public CudaUByteDataBuffer(int[] data, boolean copy) {
        super(data, copy);
    }

    public CudaUByteDataBuffer(int[] data, boolean copy, long offset) {
        super(data, copy, offset);
    }

    @Override
    public void assign(long[] indices, double[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        if (contiguous) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException("Only contiguous supported");
    }

    @Override
    protected DataBuffer create(long length) {
        return new CudaUByteDataBuffer(length);
    }

    @Override
    public float[] getFloatsAt(long offset, long inc, int length) {
        return super.getFloatsAt(offset, inc, length);
    }

    @Override
    public double[] getDoublesAt(long offset, long inc, int length) {
        return ArrayUtil.toDoubles(this.getFloatsAt(offset, inc, length));
    }

    @Override
    public void setData(float[] data) {
        this.setData(ArrayUtil.toShorts(data));
    }

    @Override
    public void setData(int[] data) {
        this.setData(ArrayUtil.toShorts(data));
    }

    @Override
    public void setData(double[] data) {
        this.setData(ArrayUtil.toFloats(data));
    }

    @Override
    public DataType dataType() {
        return DataType.UBYTE;
    }

    @Override
    public float[] asFloat() {
        return super.asFloat();
    }

    @Override
    public double[] asDouble() {
        return ArrayUtil.toDoubles(this.asFloat());
    }

    @Override
    public int[] asInt() {
        return ArrayUtil.toInts(this.asFloat());
    }

    @Override
    public double getDouble(long i) {
        return super.getFloat(i);
    }

    @Override
    public DataBuffer create(double[] data) {
        return new CudaUByteDataBuffer(data);
    }

    @Override
    public DataBuffer create(float[] data) {
        return new CudaUByteDataBuffer(data);
    }

    @Override
    public DataBuffer create(int[] data) {
        return new CudaUByteDataBuffer(data);
    }

    @Override
    public void flush() {
    }
}

