/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.buffer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import lombok.NonNull;
import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.Bfloat16Indexer;
import org.bytedeco.javacpp.indexer.BooleanIndexer;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.HalfIndexer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UIntIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.jita.allocator.enums.AllocationStatus;
import org.nd4j.jita.allocator.enums.CudaConstants;
import org.nd4j.jita.allocator.impl.AllocationPoint;
import org.nd4j.jita.allocator.impl.AllocationShape;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.impl.CudaDeallocator;
import org.nd4j.jita.allocator.pointers.CudaPointer;
import org.nd4j.jita.allocator.pointers.cuda.cudaStream_t;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.linalg.api.memory.Deallocatable;
import org.nd4j.linalg.api.memory.Deallocator;
import org.nd4j.linalg.api.memory.MemcpyDirection;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.enums.MemoryKind;
import org.nd4j.linalg.api.memory.enums.MirroringPolicy;
import org.nd4j.linalg.api.memory.pointers.PagedPointer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.performance.PerformanceTracker;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.buffer.JCudaBuffer;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.linalg.util.LongUtils;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.OpaqueDataBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCudaDataBuffer
extends BaseDataBuffer
implements JCudaBuffer,
Deallocatable {
    protected OpaqueDataBuffer ptrDataBuffer;
    protected volatile transient AllocationPoint allocationPoint;
    private static AtomicAllocator allocator = AtomicAllocator.getInstance();
    private static Logger log = LoggerFactory.getLogger(BaseCudaDataBuffer.class);
    protected DataType globalType = DataTypeUtil.getDtypeFromContext();

    public BaseCudaDataBuffer() {
    }

    public OpaqueDataBuffer getOpaqueDataBuffer() {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        return this.ptrDataBuffer;
    }

    public BaseCudaDataBuffer(@NonNull Pointer pointer, @NonNull Pointer specialPointer, @NonNull Indexer indexer, long length) {
        if (pointer == null) {
            throw new NullPointerException("pointer is marked non-null but is null");
        }
        if (specialPointer == null) {
            throw new NullPointerException("specialPointer is marked non-null but is null");
        }
        if (indexer == null) {
            throw new NullPointerException("indexer is marked non-null but is null");
        }
        this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
        this.indexer = indexer;
        this.offset = 0L;
        this.originalOffset = 0L;
        this.underlyingLength = length;
        this.length = length;
        this.initTypeAndSize();
        this.ptrDataBuffer = OpaqueDataBuffer.externalizedDataBuffer(length, this.type, pointer, specialPointer);
        this.allocationPoint = new AllocationPoint(this.ptrDataBuffer, (long)this.type.width() * length);
        Nd4j.getDeallocatorService().pickObject(this);
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
    }

    public BaseCudaDataBuffer(Pointer pointer, Indexer indexer, long length) {
        super(pointer, indexer, length);
        this.ptrDataBuffer = OpaqueDataBuffer.allocateDataBuffer(length, this.type, false);
        this.ptrDataBuffer.setPrimaryBuffer(pointer, length);
        this.allocationPoint = new AllocationPoint(this.ptrDataBuffer, length * (long)this.elementSize);
        Nd4j.getDeallocatorService().pickObject(this);
        CudaContext context = AtomicAllocator.getInstance().getDeviceContext();
        long perfD = PerformanceTracker.getInstance().helperStartTransaction();
        NativeOpsHolder.getInstance().getDeviceNativeOps().memcpyAsync(this.allocationPoint.getDevicePointer(), pointer, length * (long)this.getElementSize(), CudaConstants.cudaMemcpyHostToDevice, context.getSpecialStream());
        PerformanceTracker.getInstance().helperRegisterTransaction(this.allocationPoint.getDeviceId(), perfD / 2L, this.allocationPoint.getNumberOfBytes(), MemcpyDirection.HOST_TO_DEVICE);
        context.getSpecialStream().synchronize();
    }

    public BaseCudaDataBuffer(float[] data, boolean copy) {
        this(data, copy, 0L);
    }

    public BaseCudaDataBuffer(float[] data, boolean copy, MemoryWorkspace workspace) {
        this(data, copy, 0L, workspace);
    }

    public BaseCudaDataBuffer(float[] data, boolean copy, long offset) {
        this((long)data.length, 4, false);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
        this.set(data, this.length, offset, offset);
    }

    public BaseCudaDataBuffer(double[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        this(data.length, 8, false, workspace);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
        this.set(data, this.length, offset, offset);
    }

    public BaseCudaDataBuffer(float[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        this(data.length, 4, false, workspace);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
        this.set(data, this.length, offset, offset);
    }

    public BaseCudaDataBuffer(double[] data, boolean copy) {
        this(data, copy, 0L);
    }

    public BaseCudaDataBuffer(double[] data, boolean copy, long offset) {
        this((long)data.length, 8, false);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
        this.set(data, this.length, offset, offset);
    }

    public BaseCudaDataBuffer(int[] data, boolean copy) {
        this(data, copy, 0L);
    }

    public BaseCudaDataBuffer(int[] data, boolean copy, MemoryWorkspace workspace) {
        this(data, copy, 0L, workspace);
    }

    public BaseCudaDataBuffer(int[] data, boolean copy, long offset) {
        this((long)data.length, 4, false);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
        this.set(data, this.length, offset, offset);
    }

    public BaseCudaDataBuffer(int[] data, boolean copy, long offset, MemoryWorkspace workspace) {
        this(data.length, 4, false, workspace);
        this.offset = offset;
        this.originalOffset = offset;
        this.length = (long)data.length - offset;
        this.underlyingLength = data.length;
        this.set(data, this.length, offset, offset);
    }

    protected void initPointers(long length, DataType dtype, boolean initialize) {
        this.initPointers(length, Nd4j.sizeOfDataType(dtype), initialize);
    }

    public void lazyAllocateHostPointer() {
        if (this.length() == 0L) {
            return;
        }
        if (this.indexer == null || this.pointer == null || this.pointer.address() == 0L) {
            this.initHostPointerAndIndexer();
        } else if (this.allocationPoint.getHostPointer() != null && this.allocationPoint.getHostPointer().address() != this.pointer.address()) {
            this.initHostPointerAndIndexer();
        }
    }

    protected BaseCudaDataBuffer(ByteBuffer buffer, DataType dtype, long length, long offset) {
        this(length, Nd4j.sizeOfDataType(dtype));
        Pointer temp = null;
        switch (this.dataType()) {
            case DOUBLE: {
                temp = new DoublePointer(buffer.asDoubleBuffer());
                break;
            }
            case FLOAT: {
                temp = new FloatPointer(buffer.asFloatBuffer());
                break;
            }
            case HALF: {
                temp = new ShortPointer(buffer.asShortBuffer());
                break;
            }
            case LONG: {
                temp = new LongPointer(buffer.asLongBuffer());
                break;
            }
            case INT: {
                temp = new IntPointer(buffer.asIntBuffer());
                break;
            }
            case SHORT: {
                temp = new ShortPointer(buffer.asShortBuffer());
                break;
            }
            case UBYTE: 
            case BYTE: {
                temp = new BytePointer(buffer);
                break;
            }
            case BOOL: {
                temp = new BooleanPointer(this.length());
                break;
            }
            case UTF8: {
                temp = new BytePointer(this.length());
                break;
            }
            case BFLOAT16: {
                temp = new ShortPointer(this.length());
                break;
            }
            case UINT16: {
                temp = new ShortPointer(this.length());
                break;
            }
            case UINT32: {
                temp = new IntPointer(this.length());
                break;
            }
            case UINT64: {
                temp = new LongPointer(this.length());
            }
        }
        cudaStream_t stream = AtomicAllocator.getInstance().getDeviceContext().getSpecialStream();
        Pointer ptr = this.ptrDataBuffer.specialBuffer();
        if (offset > 0L) {
            temp = new PagedPointer(temp.address() + offset * (long)this.getElementSize());
        }
        NativeOpsHolder.getInstance().getDeviceNativeOps().memcpyAsync(ptr, temp, length * (long)Nd4j.sizeOfDataType(dtype), CudaConstants.cudaMemcpyHostToDevice, stream);
        stream.synchronize();
        this.allocationPoint.tickDeviceWrite();
    }

    protected void initHostPointerAndIndexer() {
        if (this.length() == 0L) {
            return;
        }
        if (this.allocationPoint.getHostPointer() == null) {
            AllocationStatus location = this.allocationPoint.getAllocationStatus();
            if (this.parentWorkspace == null) {
                NativeOpsHolder.getInstance().getDeviceNativeOps().dbAllocatePrimaryBuffer(this.ptrDataBuffer);
            } else {
                PagedPointer ptr = this.parentWorkspace.alloc(this.length * (long)this.elementSize, MemoryKind.HOST, this.dataType(), false);
                this.ptrDataBuffer.setPrimaryBuffer(ptr, this.length);
            }
            this.allocationPoint.setAllocationStatus(location);
            this.allocationPoint.tickDeviceWrite();
        }
        Pointer hostPointer = this.allocationPoint.getHostPointer();
        assert (hostPointer != null);
        switch (this.dataType()) {
            case DOUBLE: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asDoublePointer();
                this.indexer = DoubleIndexer.create((DoublePointer)this.pointer);
                break;
            }
            case FLOAT: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asFloatPointer();
                this.indexer = FloatIndexer.create((FloatPointer)this.pointer);
                break;
            }
            case UINT32: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asIntPointer();
                this.indexer = UIntIndexer.create((IntPointer)this.pointer);
                break;
            }
            case INT: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asIntPointer();
                this.indexer = IntIndexer.create((IntPointer)this.pointer);
                break;
            }
            case BFLOAT16: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asShortPointer();
                this.indexer = Bfloat16Indexer.create((ShortPointer)this.pointer);
                break;
            }
            case HALF: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asShortPointer();
                this.indexer = HalfIndexer.create((ShortPointer)this.pointer);
                break;
            }
            case LONG: 
            case UINT64: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asLongPointer();
                this.indexer = LongIndexer.create((LongPointer)this.pointer);
                break;
            }
            case UINT16: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asShortPointer();
                this.indexer = UShortIndexer.create((ShortPointer)this.pointer);
                break;
            }
            case SHORT: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asShortPointer();
                this.indexer = ShortIndexer.create((ShortPointer)this.pointer);
                break;
            }
            case UBYTE: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asBytePointer();
                this.indexer = UByteIndexer.create((BytePointer)this.pointer);
                break;
            }
            case BYTE: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asBytePointer();
                this.indexer = ByteIndexer.create((BytePointer)this.pointer);
                break;
            }
            case BOOL: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asBooleanPointer();
                this.indexer = BooleanIndexer.create((BooleanPointer)this.pointer);
                break;
            }
            case UTF8: {
                this.pointer = new CudaPointer(hostPointer, this.length, 0L).asBytePointer();
                this.indexer = ByteIndexer.create((BytePointer)this.pointer);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected void initPointers(long length, int elementSize, boolean initialize) {
        this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
        this.length = length;
        this.elementSize = (byte)elementSize;
        this.offset = 0L;
        this.originalOffset = 0L;
        this.ptrDataBuffer = OpaqueDataBuffer.allocateDataBuffer(length, this.type, false);
        this.allocationPoint = new AllocationPoint(this.ptrDataBuffer, length * (long)this.type.width());
        if (initialize) {
            CudaContext ctx = AtomicAllocator.getInstance().getDeviceContext();
            Pointer devicePtr = this.allocationPoint.getDevicePointer();
            NativeOpsHolder.getInstance().getDeviceNativeOps().memsetAsync(devicePtr, 0, length * (long)elementSize, 0, ctx.getSpecialStream());
            ctx.getSpecialStream().synchronize();
        }
        Nd4j.getDeallocatorService().pickObject(this);
    }

    public BaseCudaDataBuffer(long length, int elementSize, boolean initialize) {
        this.initTypeAndSize();
        this.initPointers(length, elementSize, initialize);
    }

    public BaseCudaDataBuffer(long length, int elementSize, boolean initialize, @NonNull MemoryWorkspace workspace) {
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
        this.initTypeAndSize();
        this.attached = true;
        this.parentWorkspace = workspace;
        this.length = length;
        this.offset = 0L;
        this.originalOffset = 0L;
        if (workspace.getWorkspaceConfiguration().getPolicyMirroring() == MirroringPolicy.FULL) {
            PagedPointer devicePtr = workspace.alloc(length * (long)elementSize, MemoryKind.DEVICE, this.type, initialize);
            this.ptrDataBuffer = OpaqueDataBuffer.externalizedDataBuffer(this.length, this.type, null, devicePtr);
            if (initialize) {
                CudaContext ctx = AtomicAllocator.getInstance().getDeviceContext();
                NativeOpsHolder.getInstance().getDeviceNativeOps().memsetAsync(devicePtr, 0, length * (long)elementSize, 0, ctx.getSpecialStream());
                ctx.getSpecialStream().synchronize();
            }
        } else {
            PagedPointer devicePtr = workspace.alloc(length * (long)elementSize, MemoryKind.HOST, this.type, initialize);
            this.ptrDataBuffer = OpaqueDataBuffer.externalizedDataBuffer(this.length, this.type, null, devicePtr);
            if (initialize) {
                CudaContext ctx = AtomicAllocator.getInstance().getDeviceContext();
                NativeOpsHolder.getInstance().getDeviceNativeOps().memsetAsync(devicePtr, 0, length * (long)elementSize, 0, ctx.getSpecialStream());
                ctx.getSpecialStream().synchronize();
            }
        }
        this.allocationPoint = new AllocationPoint(this.ptrDataBuffer, (long)elementSize * length);
        Nd4j.getDeallocatorService().pickObject(this);
        this.workspaceGenerationId = workspace.getGenerationId();
        this.attached = true;
        this.parentWorkspace = workspace;
    }

    @Override
    protected void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public BaseCudaDataBuffer(long length, int elementSize) {
        this(length, elementSize, true);
    }

    public BaseCudaDataBuffer(long length, int elementSize, MemoryWorkspace workspace) {
        this(length, elementSize, true, workspace);
    }

    public BaseCudaDataBuffer(long length, int elementSize, long offset) {
        this(length, elementSize);
        this.offset = offset;
        this.originalOffset = offset;
    }

    public BaseCudaDataBuffer(@NonNull DataBuffer underlyingBuffer, long length, long offset) {
        if (underlyingBuffer == null) {
            throw new NullPointerException("underlyingBuffer is marked non-null but is null");
        }
        if (underlyingBuffer.wasClosed()) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
        this.initTypeAndSize();
        this.wrappedDataBuffer = underlyingBuffer;
        this.originalBuffer = underlyingBuffer.originalDataBuffer() == null ? underlyingBuffer : underlyingBuffer.originalDataBuffer();
        this.length = length;
        this.offset = offset;
        this.originalOffset = offset;
        this.elementSize = (byte)underlyingBuffer.getElementSize();
        ((BaseCudaDataBuffer)underlyingBuffer).lazyAllocateHostPointer();
        this.ptrDataBuffer = ((BaseCudaDataBuffer)underlyingBuffer).ptrDataBuffer.createView(length * (long)underlyingBuffer.getElementSize(), offset * (long)underlyingBuffer.getElementSize());
        this.allocationPoint = new AllocationPoint(this.ptrDataBuffer, length);
        Pointer hostPointer = this.allocationPoint.getHostPointer();
        Nd4j.getDeallocatorService().pickObject(this);
        switch (underlyingBuffer.dataType()) {
            case DOUBLE: {
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asDoublePointer();
                this.indexer = DoubleIndexer.create((DoublePointer)this.pointer);
                break;
            }
            case FLOAT: {
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asFloatPointer();
                this.indexer = FloatIndexer.create((FloatPointer)this.pointer);
                break;
            }
            case UINT32: {
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asIntPointer();
                this.indexer = UIntIndexer.create((IntPointer)this.pointer);
                break;
            }
            case INT: {
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asIntPointer();
                this.indexer = IntIndexer.create((IntPointer)this.pointer);
                break;
            }
            case BFLOAT16: {
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asShortPointer();
                this.indexer = Bfloat16Indexer.create((ShortPointer)this.pointer);
                break;
            }
            case HALF: {
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asShortPointer();
                this.indexer = HalfIndexer.create((ShortPointer)this.pointer);
                break;
            }
            case LONG: 
            case UINT64: {
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asLongPointer();
                this.indexer = LongIndexer.create((LongPointer)this.pointer);
                break;
            }
            case UINT16: {
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asShortPointer();
                this.indexer = UShortIndexer.create((ShortPointer)this.pointer);
                break;
            }
            case SHORT: {
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asShortPointer();
                this.indexer = ShortIndexer.create((ShortPointer)this.pointer);
                break;
            }
            case BOOL: {
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asBooleanPointer();
                this.indexer = BooleanIndexer.create((BooleanPointer)this.pointer);
                break;
            }
            case BYTE: {
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asBytePointer();
                this.indexer = ByteIndexer.create((BytePointer)this.pointer);
                break;
            }
            case UBYTE: {
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asBytePointer();
                this.indexer = UByteIndexer.create((BytePointer)this.pointer);
                break;
            }
            case UTF8: {
                Preconditions.checkArgument(offset == 0L, "String array can't be a view");
                this.pointer = new CudaPointer(hostPointer, this.originalBuffer.length()).asBytePointer();
                this.indexer = ByteIndexer.create((BytePointer)this.pointer);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public BaseCudaDataBuffer(long length) {
        this(length, Nd4j.sizeOfDataType(Nd4j.dataType()));
    }

    public BaseCudaDataBuffer(float[] data) {
        this((long)data.length, Nd4j.sizeOfDataType(DataType.FLOAT), false);
        this.set(data, (long)data.length, 0L, 0L);
    }

    public BaseCudaDataBuffer(int[] data) {
        this((long)data.length, Nd4j.sizeOfDataType(DataType.INT), false);
        this.set(data, (long)data.length, 0L, 0L);
    }

    public BaseCudaDataBuffer(long[] data) {
        this((long)data.length, Nd4j.sizeOfDataType(DataType.LONG), false);
        this.set(data, (long)data.length, 0L, 0L);
    }

    public BaseCudaDataBuffer(long[] data, boolean copy) {
        this((long)data.length, Nd4j.sizeOfDataType(DataType.LONG), false);
        if (copy) {
            this.set(data, (long)data.length, 0L, 0L);
        }
    }

    public BaseCudaDataBuffer(double[] data) {
        this((long)data.length, Nd4j.sizeOfDataType(DataType.DOUBLE), false);
        this.set(data, (long)data.length, 0L, 0L);
    }

    @Override
    public long address() {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        return this.allocationPoint.getHostPointer().address();
    }

    @Override
    public long platformAddress() {
        return this.allocationPoint.getDevicePointer().address();
    }

    @Override
    public Pointer pointer() {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        this.lazyAllocateHostPointer();
        return super.pointer();
    }

    public void set(int[] data, long length, long srcOffset, long dstOffset) {
        switch (this.dataType()) {
            case BOOL: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case BYTE: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case UBYTE: {
                for (int e = 0; e < data.length; ++e) {
                    this.put((long)e, data[e]);
                }
                break;
            }
            case SHORT: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toShorts(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case INT: {
                IntPointer pointer = new IntPointer(data);
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case LONG: {
                LongPointer pointer = new LongPointer(LongUtils.toLongs(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case HALF: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toHalfs(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case FLOAT: {
                FloatPointer pointer = new FloatPointer(ArrayUtil.toFloats(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case DOUBLE: {
                DoublePointer pointer = new DoublePointer(ArrayUtil.toDouble(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)this.dataType()));
            }
        }
    }

    public void set(long[] data, long length, long srcOffset, long dstOffset) {
        switch (this.dataType()) {
            case BOOL: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case BYTE: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case UBYTE: {
                data = ArrayUtil.cutBelowZero(data);
                for (int e = 0; e < data.length; ++e) {
                    this.put((long)e, data[e]);
                }
                break;
            }
            case UINT16: {
                data = ArrayUtil.cutBelowZero(data);
            }
            case SHORT: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toShorts(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case UINT32: {
                data = ArrayUtil.cutBelowZero(data);
            }
            case INT: {
                IntPointer pointer = new IntPointer(ArrayUtil.toInts(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case UINT64: {
                data = ArrayUtil.cutBelowZero(data);
            }
            case LONG: {
                LongPointer pointer = new LongPointer(data);
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case BFLOAT16: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toBfloats(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case HALF: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toHalfs(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case FLOAT: {
                FloatPointer pointer = new FloatPointer(ArrayUtil.toFloats(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case DOUBLE: {
                DoublePointer pointer = new DoublePointer(ArrayUtil.toDouble(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)this.dataType()));
            }
        }
    }

    public void set(float[] data, long length, long srcOffset, long dstOffset) {
        switch (this.dataType()) {
            case BOOL: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case BYTE: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case UBYTE: {
                for (int e = 0; e < data.length; ++e) {
                    this.put((long)e, data[e]);
                }
                break;
            }
            case SHORT: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toShorts(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case INT: {
                IntPointer pointer = new IntPointer(ArrayUtil.toInts(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case LONG: {
                LongPointer pointer = new LongPointer(ArrayUtil.toLongArray(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case HALF: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toHalfs(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case FLOAT: {
                FloatPointer pointer = new FloatPointer(data);
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case DOUBLE: {
                DoublePointer pointer = new DoublePointer(ArrayUtil.toDoubles(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)this.dataType()));
            }
        }
    }

    public void set(double[] data, long length, long srcOffset, long dstOffset) {
        switch (this.dataType()) {
            case BOOL: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case BYTE: {
                BytePointer pointer = new BytePointer(ArrayUtil.toBytes(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case UBYTE: {
                for (int e = 0; e < data.length; ++e) {
                    this.put((long)e, data[e]);
                }
                break;
            }
            case SHORT: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toShorts(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case INT: {
                IntPointer pointer = new IntPointer(ArrayUtil.toInts(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case LONG: {
                LongPointer pointer = new LongPointer(ArrayUtil.toLongs(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case HALF: {
                ShortPointer pointer = new ShortPointer(ArrayUtil.toHalfs(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case FLOAT: {
                FloatPointer pointer = new FloatPointer(ArrayUtil.toFloats(data));
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            case DOUBLE: {
                DoublePointer pointer = new DoublePointer(data);
                CudaPointer srcPtr = new CudaPointer(pointer.address() + srcOffset * (long)this.elementSize);
                allocator.memcpyAsync(this, srcPtr, length * (long)this.elementSize, dstOffset * (long)this.elementSize);
                pointer.address();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)this.dataType()));
            }
        }
    }

    @Override
    public void setData(int[] data) {
        if (data.length == 0) {
            return;
        }
        this.set(data, (long)data.length, 0L, 0L);
    }

    @Override
    public void setData(long[] data) {
        if (data.length == 0) {
            return;
        }
        this.set(data, (long)data.length, 0L, 0L);
    }

    @Override
    public void setData(float[] data) {
        if (data.length == 0) {
            return;
        }
        this.set(data, (long)data.length, 0L, 0L);
    }

    @Override
    public void setData(double[] data) {
        if (data.length == 0) {
            return;
        }
        this.set(data, (long)data.length, 0L, 0L);
    }

    @Override
    protected void setNioBuffer() {
        throw new UnsupportedOperationException("setNioBuffer() is not supported for CUDA backend");
    }

    @Override
    public void copyAtStride(DataBuffer buf, long n, long stride, long yStride, long offset, long yOffset) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        allocator.synchronizeHostData(buf);
        super.copyAtStride(buf, n, stride, yStride, offset, yOffset);
    }

    @Override
    public DataBuffer.AllocationMode allocationMode() {
        return this.allocationMode;
    }

    @Override
    public ByteBuffer getHostBuffer() {
        return this.pointer.asByteBuffer();
    }

    @Override
    public Pointer getHostPointer() {
        return AtomicAllocator.getInstance().getHostPointer(this);
    }

    @Override
    public Pointer getHostPointer(long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeReferencing(String id) {
    }

    @Override
    public Collection<String> references() {
        return null;
    }

    @Override
    public int getElementSize() {
        return this.elementSize;
    }

    @Override
    public void addReferencing(String id) {
    }

    @Deprecated
    public Pointer getHostPointer(INDArray arr, int stride, long offset, int length) {
        throw new UnsupportedOperationException("This method is deprecated");
    }

    @Deprecated
    public void set(Pointer pointer) {
        throw new UnsupportedOperationException("set(Pointer) is not supported");
    }

    @Override
    public void put(long i, float element) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        allocator.tickHostWrite(this);
        super.put(i, element);
    }

    @Override
    public void put(long i, boolean element) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        allocator.tickHostWrite(this);
        super.put(i, element);
    }

    @Override
    public void put(long i, double element) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        allocator.tickHostWrite(this);
        super.put(i, element);
    }

    @Override
    public void put(long i, int element) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        allocator.tickHostWrite(this);
        super.put(i, element);
    }

    @Override
    public void put(long i, long element) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        allocator.tickHostWrite(this);
        super.put(i, element);
    }

    @Override
    public Pointer addressPointer() {
        if (this.released) {
            throw new IllegalStateException("You can't use DataBuffer once it was released");
        }
        return AtomicAllocator.getInstance().getHostPointer(this);
    }

    @Deprecated
    protected void set(long index, long length, Pointer from, long inc) {
        long offset = (long)this.getElementSize() * index;
        if (offset >= this.length() * (long)this.getElementSize()) {
            throw new IllegalArgumentException("Illegal offset " + offset + " with index of " + index + " and length " + this.length());
        }
        throw new UnsupportedOperationException("Deprecated set() call");
    }

    @Deprecated
    protected void set(long index, long length, Pointer from) {
        this.set(index, length, from, 1L);
    }

    @Override
    public void assign(DataBuffer data) {
        allocator.memcpy(this, data);
    }

    @Override
    public void assign(long[] indices, float[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], data[i]);
        }
    }

    @Override
    public void assign(long[] indices, double[] data, boolean contiguous, long inc) {
        if (indices.length != data.length) {
            throw new IllegalArgumentException("Indices and data length must be the same");
        }
        if ((long)indices.length > this.length()) {
            throw new IllegalArgumentException("More elements than space to assign. This buffer is of length " + this.length() + " where the indices are of length " + data.length);
        }
        for (int i = 0; i < indices.length; ++i) {
            this.put(indices[i], data[i]);
        }
    }

    @Deprecated
    protected void set(long index, Pointer from) {
        this.set(index, 1L, from);
    }

    @Override
    public void flush() {
    }

    @Override
    public void destroy() {
    }

    @Override
    protected double getDoubleUnsynced(long index) {
        return super.getDouble(index);
    }

    @Override
    protected float getFloatUnsynced(long index) {
        return super.getFloat(index);
    }

    @Override
    protected long getLongUnsynced(long index) {
        return super.getLong(index);
    }

    @Override
    protected int getIntUnsynced(long index) {
        return super.getInt(index);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        super.write(out);
    }

    @Override
    public void write(OutputStream dos) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        super.write(dos);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        stream.defaultWriteObject();
        this.write(stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.doReadObject(stream);
    }

    @Override
    public String toString() {
        this.lazyAllocateHostPointer();
        AtomicAllocator.getInstance().synchronizeHostData(this);
        return super.toString();
    }

    @Override
    public boolean sameUnderlyingData(DataBuffer buffer) {
        return this.ptrDataBuffer.address() == ((BaseCudaDataBuffer)buffer).ptrDataBuffer.address();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this == o;
    }

    @Override
    public void read(InputStream is, DataBuffer.AllocationMode allocationMode, long length, DataType dataType) {
        if (this.allocationPoint == null) {
            this.initPointers(length, dataType, false);
        }
        super.read(is, allocationMode, length, dataType);
        this.allocationPoint.tickHostWrite();
    }

    @Override
    public void pointerIndexerByCurrentType(DataType currentType) {
    }

    public void read(DataInputStream s) {
        try {
            DataBuffer.AllocationMode savedMode = DataBuffer.AllocationMode.valueOf(s.readUTF());
            this.allocationMode = DataBuffer.AllocationMode.MIXED_DATA_TYPES;
            long locLength = 0L;
            locLength = savedMode.ordinal() < 3 ? (long)s.readInt() : s.readLong();
            boolean reallocate = locLength != this.length || this.indexer == null;
            this.length = locLength;
            DataType t = DataType.valueOf(s.readUTF());
            if (this.globalType == null && Nd4j.dataType() != null) {
                this.globalType = Nd4j.dataType();
            }
            if (t == DataType.COMPRESSED) {
                this.type = t;
                return;
            }
            this.elementSize = (byte)Nd4j.sizeOfDataType(t);
            this.allocationPoint = AtomicAllocator.getInstance().allocateMemory(this, new AllocationShape(this.length, this.elementSize, t), false);
            this.type = t;
            Nd4j.getDeallocatorService().pickObject(this);
            switch (this.type) {
                case DOUBLE: {
                    this.pointer = new CudaPointer(this.allocationPoint.getHostPointer(), this.length).asDoublePointer();
                    this.indexer = DoubleIndexer.create((DoublePointer)this.pointer);
                    break;
                }
                case FLOAT: {
                    this.pointer = new CudaPointer(this.allocationPoint.getHostPointer(), this.length).asFloatPointer();
                    this.indexer = FloatIndexer.create((FloatPointer)this.pointer);
                    break;
                }
                case HALF: {
                    this.pointer = new CudaPointer(this.allocationPoint.getHostPointer(), this.length).asShortPointer();
                    this.indexer = HalfIndexer.create((ShortPointer)this.pointer);
                    break;
                }
                case LONG: {
                    this.pointer = new CudaPointer(this.allocationPoint.getHostPointer(), this.length).asLongPointer();
                    this.indexer = LongIndexer.create((LongPointer)this.pointer);
                    break;
                }
                case INT: {
                    this.pointer = new CudaPointer(this.allocationPoint.getHostPointer(), this.length).asIntPointer();
                    this.indexer = IntIndexer.create((IntPointer)this.pointer);
                    break;
                }
                case SHORT: {
                    this.pointer = new CudaPointer(this.allocationPoint.getHostPointer(), this.length).asShortPointer();
                    this.indexer = ShortIndexer.create((ShortPointer)this.pointer);
                    break;
                }
                case UBYTE: {
                    this.pointer = new CudaPointer(this.allocationPoint.getHostPointer(), this.length).asBytePointer();
                    this.indexer = UByteIndexer.create((BytePointer)this.pointer);
                    break;
                }
                case BYTE: {
                    this.pointer = new CudaPointer(this.allocationPoint.getHostPointer(), this.length).asBytePointer();
                    this.indexer = ByteIndexer.create((BytePointer)this.pointer);
                    break;
                }
                case BOOL: {
                    this.pointer = new CudaPointer(this.allocationPoint.getHostPointer(), this.length).asBooleanPointer();
                    this.indexer = BooleanIndexer.create((BooleanPointer)this.pointer);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)this.type));
                }
            }
            this.readContent(s, t, t);
            this.allocationPoint.tickHostWrite();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        AtomicAllocator.getInstance().getFlowController().synchronizeToDevice(this.allocationPoint);
    }

    @Override
    public byte[] asBytes() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asBytes();
    }

    @Override
    public double[] asDouble() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asDouble();
    }

    @Override
    public float[] asFloat() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asFloat();
    }

    @Override
    public int[] asInt() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asInt();
    }

    @Override
    public long[] asLong() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asLong();
    }

    @Override
    public ByteBuffer asNio() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asNio();
    }

    @Override
    public DoubleBuffer asNioDouble() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asNioDouble();
    }

    @Override
    public FloatBuffer asNioFloat() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asNioFloat();
    }

    @Override
    public IntBuffer asNioInt() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.asNioInt();
    }

    @Override
    public DataBuffer dup() {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        DataBuffer buffer = this.create(this.length);
        allocator.memcpyBlocking(buffer, new CudaPointer(allocator.getHostPointer(this).address()), this.length * (long)this.elementSize, 0L);
        return buffer;
    }

    @Override
    public Number getNumber(long i) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.getNumber(i);
    }

    @Override
    public double getDouble(long i) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.getDouble(i);
    }

    @Override
    public long getLong(long i) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.getLong(i);
    }

    @Override
    public float getFloat(long i) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.getFloat(i);
    }

    @Override
    public int getInt(long ix) {
        this.lazyAllocateHostPointer();
        allocator.synchronizeHostData(this);
        return super.getInt(ix);
    }

    public void actualizePointerAndIndexer() {
        Pointer cptr = this.ptrDataBuffer.primaryBuffer();
        if (cptr != null && this.pointer != null && cptr.address() == this.pointer.address()) {
            return;
        }
        DataType t = this.dataType();
        if (t == DataType.BOOL) {
            this.pointer = new PagedPointer(cptr, this.length).asBoolPointer();
            this.setIndexer(BooleanIndexer.create((BooleanPointer)this.pointer));
        } else if (t == DataType.UBYTE) {
            this.pointer = new PagedPointer(cptr, this.length).asBytePointer();
            this.setIndexer(UByteIndexer.create((BytePointer)this.pointer));
        } else if (t == DataType.BYTE) {
            this.pointer = new PagedPointer(cptr, this.length).asBytePointer();
            this.setIndexer(ByteIndexer.create((BytePointer)this.pointer));
        } else if (t == DataType.UINT16) {
            this.pointer = new PagedPointer(cptr, this.length).asShortPointer();
            this.setIndexer(UShortIndexer.create((ShortPointer)this.pointer));
        } else if (t == DataType.SHORT) {
            this.pointer = new PagedPointer(cptr, this.length).asShortPointer();
            this.setIndexer(ShortIndexer.create((ShortPointer)this.pointer));
        } else if (t == DataType.UINT32) {
            this.pointer = new PagedPointer(cptr, this.length).asIntPointer();
            this.setIndexer(UIntIndexer.create((IntPointer)this.pointer));
        } else if (t == DataType.INT) {
            this.pointer = new PagedPointer(cptr, this.length).asIntPointer();
            this.setIndexer(IntIndexer.create((IntPointer)this.pointer));
        } else if (t == DataType.UINT64) {
            this.pointer = new PagedPointer(cptr, this.length).asLongPointer();
            this.setIndexer(LongIndexer.create((LongPointer)this.pointer));
        } else if (t == DataType.LONG) {
            this.pointer = new PagedPointer(cptr, this.length).asLongPointer();
            this.setIndexer(LongIndexer.create((LongPointer)this.pointer));
        } else if (t == DataType.BFLOAT16) {
            this.pointer = new PagedPointer(cptr, this.length).asShortPointer();
            this.setIndexer(Bfloat16Indexer.create((ShortPointer)this.pointer));
        } else if (t == DataType.HALF) {
            this.pointer = new PagedPointer(cptr, this.length).asShortPointer();
            this.setIndexer(HalfIndexer.create((ShortPointer)this.pointer));
        } else if (t == DataType.FLOAT) {
            this.pointer = new PagedPointer(cptr, this.length).asFloatPointer();
            this.setIndexer(FloatIndexer.create((FloatPointer)this.pointer));
        } else if (t == DataType.DOUBLE) {
            this.pointer = new PagedPointer(cptr, this.length).asDoublePointer();
            this.setIndexer(DoubleIndexer.create((DoublePointer)this.pointer));
        } else if (t == DataType.UTF8) {
            this.pointer = new PagedPointer(cptr, this.length()).asBytePointer();
            this.setIndexer(ByteIndexer.create((BytePointer)this.pointer));
        } else {
            throw new IllegalArgumentException("Unknown datatype: " + (Object)((Object)this.dataType()));
        }
    }

    @Override
    public DataBuffer reallocate(long length) {
        Pointer oldHostPointer = this.ptrDataBuffer.primaryBuffer();
        Pointer oldDevicePointer = this.ptrDataBuffer.specialBuffer();
        if (this.isAttached()) {
            PagedPointer nPtr;
            long capacity = length * (long)this.getElementSize();
            if (oldDevicePointer != null && oldDevicePointer.address() != 0L) {
                nPtr = this.getParentWorkspace().alloc(capacity, MemoryKind.DEVICE, this.dataType(), false);
                NativeOpsHolder.getInstance().getDeviceNativeOps().memcpySync(nPtr, oldDevicePointer, length * (long)this.getElementSize(), 3, null);
                this.ptrDataBuffer.setPrimaryBuffer(nPtr, length);
                this.allocationPoint.tickDeviceRead();
            }
            if (oldHostPointer != null && oldHostPointer.address() != 0L) {
                nPtr = this.getParentWorkspace().alloc(capacity, MemoryKind.HOST, this.dataType(), false);
                Pointer.memcpy(nPtr, oldHostPointer, this.length() * (long)this.getElementSize());
                this.ptrDataBuffer.setPrimaryBuffer(nPtr, length);
                this.allocationPoint.tickHostRead();
                switch (this.dataType()) {
                    case BOOL: {
                        this.pointer = nPtr.asBoolPointer();
                        this.indexer = BooleanIndexer.create((BooleanPointer)this.pointer);
                        break;
                    }
                    case UBYTE: 
                    case BYTE: 
                    case UTF8: {
                        this.pointer = nPtr.asBytePointer();
                        this.indexer = ByteIndexer.create((BytePointer)this.pointer);
                        break;
                    }
                    case SHORT: 
                    case UINT16: {
                        this.pointer = nPtr.asShortPointer();
                        this.indexer = ShortIndexer.create((ShortPointer)this.pointer);
                        break;
                    }
                    case UINT32: {
                        this.pointer = nPtr.asIntPointer();
                        this.indexer = UIntIndexer.create((IntPointer)this.pointer);
                        break;
                    }
                    case INT: {
                        this.pointer = nPtr.asIntPointer();
                        this.indexer = IntIndexer.create((IntPointer)this.pointer);
                        break;
                    }
                    case DOUBLE: {
                        this.pointer = nPtr.asDoublePointer();
                        this.indexer = DoubleIndexer.create((DoublePointer)this.pointer);
                        break;
                    }
                    case FLOAT: {
                        this.pointer = nPtr.asFloatPointer();
                        this.indexer = FloatIndexer.create((FloatPointer)this.pointer);
                        break;
                    }
                    case HALF: {
                        this.pointer = nPtr.asShortPointer();
                        this.indexer = HalfIndexer.create((ShortPointer)this.pointer);
                        break;
                    }
                    case BFLOAT16: {
                        this.pointer = nPtr.asShortPointer();
                        this.indexer = Bfloat16Indexer.create((ShortPointer)this.pointer);
                        break;
                    }
                    case LONG: 
                    case UINT64: {
                        this.pointer = nPtr.asLongPointer();
                        this.indexer = LongIndexer.create((LongPointer)this.pointer);
                    }
                }
            }
            this.workspaceGenerationId = this.getParentWorkspace().getGenerationId();
        } else {
            this.ptrDataBuffer.expand(length);
            PagedPointer nPtr = new PagedPointer(this.ptrDataBuffer.primaryBuffer(), length);
            switch (this.dataType()) {
                case BOOL: {
                    this.pointer = nPtr.asBoolPointer();
                    this.indexer = BooleanIndexer.create((BooleanPointer)this.pointer);
                    break;
                }
                case UBYTE: 
                case BYTE: 
                case UTF8: {
                    this.pointer = nPtr.asBytePointer();
                    this.indexer = ByteIndexer.create((BytePointer)this.pointer);
                    break;
                }
                case SHORT: 
                case UINT16: {
                    this.pointer = nPtr.asShortPointer();
                    this.indexer = ShortIndexer.create((ShortPointer)this.pointer);
                    break;
                }
                case UINT32: {
                    this.pointer = nPtr.asIntPointer();
                    this.indexer = UIntIndexer.create((IntPointer)this.pointer);
                    break;
                }
                case INT: {
                    this.pointer = nPtr.asIntPointer();
                    this.indexer = IntIndexer.create((IntPointer)this.pointer);
                    break;
                }
                case DOUBLE: {
                    this.pointer = nPtr.asDoublePointer();
                    this.indexer = DoubleIndexer.create((DoublePointer)this.pointer);
                    break;
                }
                case FLOAT: {
                    this.pointer = nPtr.asFloatPointer();
                    this.indexer = FloatIndexer.create((FloatPointer)this.pointer);
                    break;
                }
                case HALF: {
                    this.pointer = nPtr.asShortPointer();
                    this.indexer = HalfIndexer.create((ShortPointer)this.pointer);
                    break;
                }
                case BFLOAT16: {
                    this.pointer = nPtr.asShortPointer();
                    this.indexer = Bfloat16Indexer.create((ShortPointer)this.pointer);
                    break;
                }
                case LONG: 
                case UINT64: {
                    this.pointer = nPtr.asLongPointer();
                    this.indexer = LongIndexer.create((LongPointer)this.pointer);
                }
            }
        }
        this.underlyingLength = length;
        this.length = length;
        return this;
    }

    @Override
    public long capacity() {
        if (this.allocationPoint.getHostPointer() != null) {
            return this.pointer.capacity();
        }
        return this.length;
    }

    @Override
    protected void release() {
        if (!this.released) {
            this.ptrDataBuffer.closeBuffer();
            this.allocationPoint.setReleased(true);
        }
        super.release();
    }

    @Override
    public String getUniqueId() {
        return "BCDB_" + this.allocationPoint.getObjectId();
    }

    @Override
    public Deallocator deallocator() {
        return new CudaDeallocator(this);
    }

    @Override
    public int targetDevice() {
        return AtomicAllocator.getInstance().getAllocationPoint(this).getDeviceId();
    }

    @Override
    public void syncToPrimary() {
        this.ptrDataBuffer.syncToPrimary();
    }

    @Override
    public void syncToSpecial() {
        this.ptrDataBuffer.syncToSpecial();
    }

    public AllocationPoint getAllocationPoint() {
        return this.allocationPoint;
    }
}

