/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.blas;

import org.bytedeco.cuda.cudart.CUstream_st;
import org.bytedeco.cuda.cusolver.cusolverDnContext;
import org.bytedeco.cuda.global.cusolver;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.Allocator;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.pointers.CudaPointer;
import org.nd4j.jita.allocator.pointers.cuda.cusolverDnHandle_t;
import org.nd4j.linalg.api.blas.BlasException;
import org.nd4j.linalg.api.blas.impl.BaseLapack;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.GridExecutioner;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.jcublas.CublasPointer;
import org.nd4j.linalg.jcublas.buffer.BaseCudaDataBuffer;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcublasLapack
extends BaseLapack {
    private static final Logger log = LoggerFactory.getLogger(JcublasLapack.class);
    private NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private Allocator allocator = AtomicAllocator.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sgetrf(int M, int N, INDArray A, INDArray IPIV, INDArray INFO) {
        INDArray a = A;
        if (Nd4j.dataType() != DataType.FLOAT) {
            log.warn("FLOAT getrf called in DOUBLE environment");
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getDeviceContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolverDnContext solverDn = new cusolverDnContext(handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream(new cusolverDnContext(handle), new CUstream_st(ctx.getCublasStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            BaseCudaDataBuffer worksizeBuffer = (BaseCudaDataBuffer)Nd4j.getDataBufferFactory().createInt(1L);
            worksizeBuffer.lazyAllocateHostPointer();
            int stat = cusolver.cusolverDnSgetrf_bufferSize(solverDn, M, N, (FloatPointer)xAPointer.getDevicePointer(), M, (IntPointer)worksizeBuffer.addressPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSgetrf_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnSgetrf(solverDn, M, N, (FloatPointer)xAPointer.getDevicePointer(), M, new CudaPointer(workspace).asFloatPointer(), new CudaPointer(this.allocator.getPointer(IPIV, ctx)).asIntPointer(), new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSgetrf failed", stat);
            }
        }
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        this.allocator.registerAction(ctx, IPIV, new INDArray[0]);
        if (a != A) {
            A.assign(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dgetrf(int M, int N, INDArray A, INDArray IPIV, INDArray INFO) {
        INDArray a = A;
        if (Nd4j.dataType() != DataType.DOUBLE) {
            log.warn("FLOAT getrf called in FLOAT environment");
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getDeviceContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolverDnContext solverDn = new cusolverDnContext(handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream(new cusolverDnContext(handle), new CUstream_st(ctx.getCublasStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            BaseCudaDataBuffer worksizeBuffer = (BaseCudaDataBuffer)Nd4j.getDataBufferFactory().createInt(1L);
            worksizeBuffer.lazyAllocateHostPointer();
            int stat = cusolver.cusolverDnDgetrf_bufferSize(solverDn, M, N, (DoublePointer)xAPointer.getDevicePointer(), M, (IntPointer)worksizeBuffer.addressPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnDgetrf_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnDgetrf(solverDn, M, N, (DoublePointer)xAPointer.getDevicePointer(), M, new CudaPointer(workspace).asDoublePointer(), new CudaPointer(this.allocator.getPointer(IPIV, ctx)).asIntPointer(), new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSgetrf failed", stat);
            }
        }
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        this.allocator.registerAction(ctx, IPIV, new INDArray[0]);
        if (a != A) {
            A.assign(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sgeqrf(int M, int N, INDArray A, INDArray R, INDArray INFO) {
        INDArray a = A;
        INDArray r = R;
        if (Nd4j.dataType() != DataType.FLOAT) {
            log.warn("FLOAT getrf called in DOUBLE environment");
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (R != null && R.ordering() == 'c') {
            r = R.dup('f');
        }
        INDArray tau = Nd4j.createArrayFromShapeBuffer(Nd4j.getDataBufferFactory().createFloat(N), Nd4j.getShapeInfoProvider().createShapeInformation(new long[]{1L, N}, A.dataType()).getFirst());
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getDeviceContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolverDnContext solverDn = new cusolverDnContext(handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream(new cusolverDnContext(handle), new CUstream_st(ctx.getCublasStream()));
            if (result != 0) {
                throw new IllegalStateException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            CublasPointer xTauPointer = new CublasPointer(tau, ctx);
            BaseCudaDataBuffer worksizeBuffer = (BaseCudaDataBuffer)Nd4j.getDataBufferFactory().createInt(1L);
            worksizeBuffer.lazyAllocateHostPointer();
            int stat = cusolver.cusolverDnSgeqrf_bufferSize(solverDn, M, N, (FloatPointer)xAPointer.getDevicePointer(), M, (IntPointer)worksizeBuffer.addressPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSgeqrf_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnSgeqrf(solverDn, M, N, (FloatPointer)xAPointer.getDevicePointer(), M, (FloatPointer)xTauPointer.getDevicePointer(), new CudaPointer(workspace).asFloatPointer(), worksize, new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSgeqrf failed", stat);
            }
            this.allocator.registerAction(ctx, a, new INDArray[0]);
            this.allocator.registerAction(ctx, INFO, new INDArray[0]);
            if (INFO.getInt(0) != 0) {
                throw new BlasException("cusolverDnSgeqrf failed on INFO", INFO.getInt(0));
            }
            if (r != null) {
                r.assign(a.get(NDArrayIndex.interval(0, a.columns()), NDArrayIndex.all()));
                INDArrayIndex[] ix = new INDArrayIndex[2];
                for (int i = 1; i < Math.min(a.rows(), a.columns()); ++i) {
                    ix[0] = NDArrayIndex.point(i);
                    ix[1] = NDArrayIndex.interval(0, i);
                    r.put(ix, 0);
                }
            }
            stat = cusolver.cusolverDnSorgqr_bufferSize(solverDn, M, N, N, (FloatPointer)xAPointer.getDevicePointer(), M, (FloatPointer)xTauPointer.getDevicePointer(), (IntPointer)worksizeBuffer.addressPointer());
            worksize = worksizeBuffer.getInt(0L);
            workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnSorgqr(solverDn, M, N, N, (FloatPointer)xAPointer.getDevicePointer(), M, (FloatPointer)xTauPointer.getDevicePointer(), new CudaPointer(workspace).asFloatPointer(), worksize, new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSorgqr failed", stat);
            }
        }
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        if (a != A) {
            A.assign(a);
        }
        if (r != null && r != R) {
            R.assign(r);
        }
        log.debug("A: {}", (Object)A);
        if (R != null) {
            log.debug("R: {}", (Object)R);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dgeqrf(int M, int N, INDArray A, INDArray R, INDArray INFO) {
        INDArray a = A;
        INDArray r = R;
        if (Nd4j.dataType() != DataType.DOUBLE) {
            log.warn("DOUBLE getrf called in FLOAT environment");
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (R != null && R.ordering() == 'c') {
            r = R.dup('f');
        }
        INDArray tau = Nd4j.createArrayFromShapeBuffer(Nd4j.getDataBufferFactory().createDouble(N), Nd4j.getShapeInfoProvider().createShapeInformation(new long[]{1L, N}, A.dataType()));
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getDeviceContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolverDnContext solverDn = new cusolverDnContext(handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream(new cusolverDnContext(handle), new CUstream_st(ctx.getCublasStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            CublasPointer xTauPointer = new CublasPointer(tau, ctx);
            BaseCudaDataBuffer worksizeBuffer = (BaseCudaDataBuffer)Nd4j.getDataBufferFactory().createInt(1L);
            worksizeBuffer.lazyAllocateHostPointer();
            int stat = cusolver.cusolverDnDgeqrf_bufferSize(solverDn, M, N, (DoublePointer)xAPointer.getDevicePointer(), M, (IntPointer)worksizeBuffer.addressPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnDgeqrf_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnDgeqrf(solverDn, M, N, (DoublePointer)xAPointer.getDevicePointer(), M, (DoublePointer)xTauPointer.getDevicePointer(), new CudaPointer(workspace).asDoublePointer(), worksize, new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnDgeqrf failed", stat);
            }
            this.allocator.registerAction(ctx, a, new INDArray[0]);
            this.allocator.registerAction(ctx, tau, new INDArray[0]);
            this.allocator.registerAction(ctx, INFO, new INDArray[0]);
            if (INFO.getInt(0) != 0) {
                throw new BlasException("cusolverDnDgeqrf failed with info", INFO.getInt(0));
            }
            if (r != null) {
                r.assign(a.get(NDArrayIndex.interval(0, a.columns()), NDArrayIndex.all()));
                INDArrayIndex[] ix = new INDArrayIndex[2];
                for (int i = 1; i < Math.min(a.rows(), a.columns()); ++i) {
                    ix[0] = NDArrayIndex.point(i);
                    ix[1] = NDArrayIndex.interval(0, i);
                    r.put(ix, 0);
                }
            }
            stat = cusolver.cusolverDnDorgqr_bufferSize(solverDn, M, N, N, (DoublePointer)xAPointer.getDevicePointer(), M, (DoublePointer)xTauPointer.getDevicePointer(), (IntPointer)worksizeBuffer.addressPointer());
            worksize = worksizeBuffer.getInt(0L);
            workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnDorgqr(solverDn, M, N, N, (DoublePointer)xAPointer.getDevicePointer(), M, (DoublePointer)xTauPointer.getDevicePointer(), new CudaPointer(workspace).asDoublePointer(), worksize, new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnDorgqr failed", stat);
            }
        }
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        if (a != A) {
            A.assign(a);
        }
        if (r != null && r != R) {
            R.assign(r);
        }
        log.debug("A: {}", (Object)A);
        if (R != null) {
            log.debug("R: {}", (Object)R);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spotrf(byte _uplo, int N, INDArray A, INDArray INFO) {
        int i;
        INDArrayIndex[] ix;
        int uplo;
        INDArray a = A;
        int n = uplo = _uplo == 76 ? 0 : 1;
        if (A.dataType() != DataType.FLOAT) {
            log.warn("FLOAT potrf called for " + (Object)((Object)A.dataType()));
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getDeviceContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolverDnContext solverDn = new cusolverDnContext(handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream(new cusolverDnContext(handle), new CUstream_st(ctx.getCublasStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            BaseCudaDataBuffer worksizeBuffer = (BaseCudaDataBuffer)Nd4j.getDataBufferFactory().createInt(1L);
            worksizeBuffer.lazyAllocateHostPointer();
            int stat = cusolver.cusolverDnSpotrf_bufferSize(solverDn, uplo, N, (FloatPointer)xAPointer.getDevicePointer(), N, (IntPointer)worksizeBuffer.addressPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSpotrf_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnSpotrf(solverDn, uplo, N, (FloatPointer)xAPointer.getDevicePointer(), N, new CudaPointer(workspace).asFloatPointer(), worksize, new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSpotrf failed", stat);
            }
        }
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        if (a != A) {
            A.assign(a);
        }
        if (uplo == 1) {
            A.assign(A.transpose());
            ix = new INDArrayIndex[2];
            for (i = 1; i < Math.min(A.rows(), A.columns()); ++i) {
                ix[0] = NDArrayIndex.point(i);
                ix[1] = NDArrayIndex.interval(0, i);
                A.put(ix, 0);
            }
        } else {
            ix = new INDArrayIndex[2];
            for (i = 0; i < Math.min(A.rows(), A.columns() - 1); ++i) {
                ix[0] = NDArrayIndex.point(i);
                ix[1] = NDArrayIndex.interval(i + 1, A.columns());
                A.put(ix, 0);
            }
        }
        log.debug("A: {}", (Object)A);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dpotrf(byte _uplo, int N, INDArray A, INDArray INFO) {
        int i;
        INDArrayIndex[] ix;
        int uplo;
        INDArray a = A;
        int n = uplo = _uplo == 76 ? 0 : 1;
        if (A.dataType() != DataType.DOUBLE) {
            log.warn("DOUBLE potrf called for " + (Object)((Object)A.dataType()));
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getDeviceContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolverDnContext solverDn = new cusolverDnContext(handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream(solverDn, new CUstream_st(ctx.getCublasStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            BaseCudaDataBuffer worksizeBuffer = (BaseCudaDataBuffer)Nd4j.getDataBufferFactory().createInt(1L);
            worksizeBuffer.lazyAllocateHostPointer();
            int stat = cusolver.cusolverDnDpotrf_bufferSize(solverDn, uplo, N, (DoublePointer)xAPointer.getDevicePointer(), N, (IntPointer)worksizeBuffer.addressPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnDpotrf_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType(DataType.DOUBLE));
            stat = cusolver.cusolverDnDpotrf(solverDn, uplo, N, (DoublePointer)xAPointer.getDevicePointer(), N, new CudaPointer(workspace).asDoublePointer(), worksize, new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnDpotrf failed", stat);
            }
        }
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        if (a != A) {
            A.assign(a);
        }
        if (uplo == 1) {
            A.assign(A.transpose());
            ix = new INDArrayIndex[2];
            for (i = 1; i < Math.min(A.rows(), A.columns()); ++i) {
                ix[0] = NDArrayIndex.point(i);
                ix[1] = NDArrayIndex.interval(0, i);
                A.put(ix, 0);
            }
        } else {
            ix = new INDArrayIndex[2];
            for (i = 0; i < Math.min(A.rows(), A.columns() - 1); ++i) {
                ix[0] = NDArrayIndex.point(i);
                ix[1] = NDArrayIndex.interval(i + 1, A.columns());
                A.put(ix, 0);
            }
        }
        log.debug("A: {}", (Object)A);
    }

    @Override
    public void getri(int N, INDArray A, int lda, int[] IPIV, INDArray WORK, int lwork, int INFO) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sgesvd(byte jobu, byte jobvt, int M, int N, INDArray A, INDArray S, INDArray U, INDArray VT, INDArray INFO) {
        if (Nd4j.dataType() != DataType.FLOAT) {
            log.warn("FLOAT gesvd called in DOUBLE environment");
        }
        INDArray a = A;
        INDArray u = U;
        INDArray vt = VT;
        boolean hadToTransposeA = false;
        if (M < N) {
            hadToTransposeA = true;
            int tmp1 = N;
            N = M;
            M = tmp1;
            byte tmp2 = jobu;
            jobu = jobvt;
            jobvt = tmp2;
            a = A.transpose().dup('f');
            u = VT == null ? null : VT.transpose().dup('f');
            vt = U == null ? null : U.transpose().dup('f');
        } else {
            if (A.ordering() == 'c') {
                a = A.dup('f');
            }
            if (U != null && U.ordering() == 'c') {
                u = U.dup('f');
            }
            if (VT != null && VT.ordering() == 'c') {
                vt = VT.dup('f');
            }
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getDeviceContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolverDnContext solverDn = new cusolverDnContext(handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream(new cusolverDnContext(handle), new CUstream_st(ctx.getCublasStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            BaseCudaDataBuffer worksizeBuffer = (BaseCudaDataBuffer)Nd4j.getDataBufferFactory().createInt(1L);
            worksizeBuffer.lazyAllocateHostPointer();
            int stat = cusolver.cusolverDnSgesvd_bufferSize(solverDn, M, N, (IntPointer)worksizeBuffer.addressPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSgesvd_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            DataBuffer rwork = Nd4j.getDataBufferFactory().createFloat((M < N ? M : N) - 1);
            stat = cusolver.cusolverDnSgesvd(solverDn, jobu, jobvt, M, N, (FloatPointer)xAPointer.getDevicePointer(), M, new CudaPointer(this.allocator.getPointer(S, ctx)).asFloatPointer(), u == null ? null : new CudaPointer(this.allocator.getPointer(u, ctx)).asFloatPointer(), M, vt == null ? null : new CudaPointer(this.allocator.getPointer(vt, ctx)).asFloatPointer(), N, new CudaPointer(workspace).asFloatPointer(), worksize, new CudaPointer(this.allocator.getPointer(rwork, ctx)).asFloatPointer(), new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSgesvd failed", stat);
            }
        }
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        this.allocator.registerAction(ctx, S, new INDArray[0]);
        if (u != null) {
            this.allocator.registerAction(ctx, u, new INDArray[0]);
        }
        if (vt != null) {
            this.allocator.registerAction(ctx, vt, new INDArray[0]);
        }
        if (hadToTransposeA) {
            if (vt != null) {
                U.assign(vt.transpose());
            }
            if (u != null) {
                VT.assign(u.transpose());
            }
        } else {
            if (u != U) {
                U.assign(u);
            }
            if (vt != VT) {
                VT.assign(vt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dgesvd(byte jobu, byte jobvt, int M, int N, INDArray A, INDArray S, INDArray U, INDArray VT, INDArray INFO) {
        INDArray a = A;
        INDArray u = U;
        INDArray vt = VT;
        boolean hadToTransposeA = false;
        if (M < N) {
            hadToTransposeA = true;
            int tmp1 = N;
            N = M;
            M = tmp1;
            byte tmp2 = jobu;
            jobu = jobvt;
            jobvt = tmp2;
            a = A.transpose().dup('f');
            u = VT == null ? null : VT.transpose().dup('f');
            vt = U == null ? null : U.transpose().dup('f');
        } else {
            if (A.ordering() == 'c') {
                a = A.dup('f');
            }
            if (U != null && U.ordering() == 'c') {
                u = U.dup('f');
            }
            if (VT != null && VT.ordering() == 'c') {
                vt = VT.dup('f');
            }
        }
        if (Nd4j.dataType() != DataType.DOUBLE) {
            log.warn("DOUBLE gesvd called in FLOAT environment");
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getDeviceContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolverDnContext solverDn = new cusolverDnContext(handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream(new cusolverDnContext(handle), new CUstream_st(ctx.getCublasStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            BaseCudaDataBuffer worksizeBuffer = (BaseCudaDataBuffer)Nd4j.getDataBufferFactory().createInt(1L);
            worksizeBuffer.lazyAllocateHostPointer();
            int stat = cusolver.cusolverDnSgesvd_bufferSize(solverDn, M, N, (IntPointer)worksizeBuffer.addressPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSgesvd_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            DataBuffer rwork = Nd4j.getDataBufferFactory().createDouble((M < N ? M : N) - 1);
            stat = cusolver.cusolverDnDgesvd(solverDn, jobu, jobvt, M, N, (DoublePointer)xAPointer.getDevicePointer(), M, new CudaPointer(this.allocator.getPointer(S, ctx)).asDoublePointer(), u == null ? null : new CudaPointer(this.allocator.getPointer(u, ctx)).asDoublePointer(), M, vt == null ? null : new CudaPointer(this.allocator.getPointer(vt, ctx)).asDoublePointer(), N, new CudaPointer(workspace).asDoublePointer(), worksize, new CudaPointer(this.allocator.getPointer(rwork, ctx)).asDoublePointer(), new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnDgesvd failed" + stat);
            }
        }
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        this.allocator.registerAction(ctx, S, new INDArray[0]);
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        if (u != null) {
            this.allocator.registerAction(ctx, u, new INDArray[0]);
        }
        if (vt != null) {
            this.allocator.registerAction(ctx, vt, new INDArray[0]);
        }
        if (hadToTransposeA) {
            if (vt != null) {
                U.assign(vt.transpose());
            }
            if (u != null) {
                VT.assign(u.transpose());
            }
        } else {
            if (u != U) {
                U.assign(u);
            }
            if (vt != VT) {
                VT.assign(vt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int ssyev(char _jobz, char _uplo, int N, INDArray A, INDArray R) {
        int status = -1;
        int jobz = _jobz == 'V' ? 1 : 0;
        int uplo = _uplo == 'L' ? 0 : 1;
        INDArray a = A;
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (A.rows() > Integer.MAX_VALUE) {
            throw new RuntimeException("Rows overflow");
        }
        int M = A.rows();
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getDeviceContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolverDnContext solverDn = new cusolverDnContext(handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            status = cusolver.cusolverDnSetStream(new cusolverDnContext(handle), new CUstream_st(ctx.getCublasStream()));
            if (status == 0) {
                CublasPointer xAPointer = new CublasPointer(a, ctx);
                CublasPointer xRPointer = new CublasPointer(R, ctx);
                BaseCudaDataBuffer worksizeBuffer = (BaseCudaDataBuffer)Nd4j.getDataBufferFactory().createInt(1L);
                worksizeBuffer.lazyAllocateHostPointer();
                status = cusolver.cusolverDnSsyevd_bufferSize(solverDn, jobz, uplo, M, (FloatPointer)xAPointer.getDevicePointer(), M, (FloatPointer)xRPointer.getDevicePointer(), (IntPointer)worksizeBuffer.addressPointer());
                if (status == 0) {
                    int worksize = worksizeBuffer.getInt(0L);
                    Workspace workspace = new Workspace(worksize * 4);
                    INDArray INFO = Nd4j.createArrayFromShapeBuffer(Nd4j.getDataBufferFactory().createInt(1L), Nd4j.getShapeInfoProvider().createShapeInformation(new long[]{1L, 1L}, A.dataType()));
                    status = cusolver.cusolverDnSsyevd(solverDn, jobz, uplo, M, (FloatPointer)xAPointer.getDevicePointer(), M, (FloatPointer)xRPointer.getDevicePointer(), new CudaPointer(workspace).asFloatPointer(), worksize, new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
                    this.allocator.registerAction(ctx, INFO, new INDArray[0]);
                    if (status == 0) {
                        status = INFO.getInt(0);
                    }
                }
            }
        }
        if (status == 0) {
            this.allocator.registerAction(ctx, R, new INDArray[0]);
            this.allocator.registerAction(ctx, a, new INDArray[0]);
            if (a != A) {
                A.assign(a);
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int dsyev(char _jobz, char _uplo, int N, INDArray A, INDArray R) {
        int status = -1;
        int jobz = _jobz == 'V' ? 1 : 0;
        int uplo = _uplo == 'L' ? 0 : 1;
        INDArray a = A;
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (A.rows() > Integer.MAX_VALUE) {
            throw new RuntimeException("Rows overflow");
        }
        int M = A.rows();
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = this.allocator.getDeviceContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolverDnContext solverDn = new cusolverDnContext(handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            status = cusolver.cusolverDnSetStream(new cusolverDnContext(handle), new CUstream_st(ctx.getCublasStream()));
            if (status == 0) {
                CublasPointer xAPointer = new CublasPointer(a, ctx);
                CublasPointer xRPointer = new CublasPointer(R, ctx);
                BaseCudaDataBuffer worksizeBuffer = (BaseCudaDataBuffer)Nd4j.getDataBufferFactory().createInt(1L);
                worksizeBuffer.lazyAllocateHostPointer();
                status = cusolver.cusolverDnDsyevd_bufferSize(solverDn, jobz, uplo, M, (DoublePointer)xAPointer.getDevicePointer(), M, (DoublePointer)xRPointer.getDevicePointer(), (IntPointer)worksizeBuffer.addressPointer());
                if (status == 0) {
                    int worksize = worksizeBuffer.getInt(0L);
                    Workspace workspace = new Workspace(worksize * 8);
                    INDArray INFO = Nd4j.createArrayFromShapeBuffer(Nd4j.getDataBufferFactory().createInt(1L), Nd4j.getShapeInfoProvider().createShapeInformation(new long[]{1L, 1L}, A.dataType()));
                    status = cusolver.cusolverDnDsyevd(solverDn, jobz, uplo, M, (DoublePointer)xAPointer.getDevicePointer(), M, (DoublePointer)xRPointer.getDevicePointer(), new CudaPointer(workspace).asDoublePointer(), worksize, new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
                    this.allocator.registerAction(ctx, INFO, new INDArray[0]);
                    if (status == 0) {
                        status = INFO.getInt(0);
                    }
                }
            }
        }
        if (status == 0) {
            this.allocator.registerAction(ctx, R, new INDArray[0]);
            this.allocator.registerAction(ctx, a, new INDArray[0]);
            if (a != A) {
                A.assign(a);
            }
        }
        return status;
    }

    static class Workspace
    extends Pointer {
        public Workspace(long size) {
            super(NativeOpsHolder.getInstance().getDeviceNativeOps().mallocDevice(size, 0, 0));
            this.deallocator(new Pointer.Deallocator(){

                @Override
                public void deallocate() {
                    NativeOpsHolder.getInstance().getDeviceNativeOps().freeDevice(this, 0);
                }
            });
        }
    }
}

