/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory.ops;

import org.nd4j.common.base.Preconditions;
import org.nd4j.enums.DataFormat;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.image.ExtractImagePatches;
import org.nd4j.linalg.api.ops.impl.layers.convolution.AvgPooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.AvgPooling3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Col2Im;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv1D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DeConv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DeConv3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DepthToSpace;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DepthwiseConv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Im2col;
import org.nd4j.linalg.api.ops.impl.layers.convolution.LocalResponseNormalization;
import org.nd4j.linalg.api.ops.impl.layers.convolution.MaxPoolWithArgmax;
import org.nd4j.linalg.api.ops.impl.layers.convolution.MaxPooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.MaxPooling3D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.SConv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.SpaceToDepth;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Upsampling2d;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Upsampling3d;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv1DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.LocalResponseNormalizationConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling3DConfig;
import org.nd4j.linalg.api.ops.impl.transforms.custom.BatchToSpace;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Dilation2D;
import org.nd4j.linalg.api.ops.impl.transforms.custom.SpaceToBatch;
import org.nd4j.linalg.factory.NDValidation;
import org.nd4j.linalg.factory.Nd4j;

public class NDCNN {
    public INDArray avgPooling2d(INDArray input, Pooling2DConfig Pooling2DConfig2) {
        NDValidation.validateNumerical("avgPooling2d", "input", input);
        return Nd4j.exec(new AvgPooling2D(input, Pooling2DConfig2))[0];
    }

    public INDArray avgPooling3d(INDArray input, Pooling3DConfig Pooling3DConfig2) {
        NDValidation.validateNumerical("avgPooling3d", "input", input);
        return Nd4j.exec(new AvgPooling3D(input, Pooling3DConfig2))[0];
    }

    public INDArray batchToSpace(INDArray x, int[] blocks, int[] croppingTop, int ... croppingBottom) {
        NDValidation.validateNumerical("batchToSpace", "x", x);
        Preconditions.checkArgument(blocks.length == 2, "blocks has incorrect size/length. Expected: blocks.length == 2, got %s", blocks.length);
        Preconditions.checkArgument(croppingTop.length == 2, "croppingTop has incorrect size/length. Expected: croppingTop.length == 2, got %s", croppingTop.length);
        Preconditions.checkArgument(croppingBottom.length == 2, "croppingBottom has incorrect size/length. Expected: croppingBottom.length == 2, got %s", croppingBottom.length);
        return Nd4j.exec(new BatchToSpace(x, blocks, croppingTop, croppingBottom))[0];
    }

    public INDArray col2Im(INDArray in, Conv2DConfig Conv2DConfig2) {
        NDValidation.validateNumerical("col2Im", "in", in);
        return Nd4j.exec(new Col2Im(in, Conv2DConfig2))[0];
    }

    public INDArray conv1d(INDArray input, INDArray weights, INDArray bias, Conv1DConfig Conv1DConfig2) {
        NDValidation.validateNumerical("conv1d", "input", input);
        NDValidation.validateNumerical("conv1d", "weights", weights);
        NDValidation.validateNumerical("conv1d", "bias", bias);
        return Nd4j.exec(new Conv1D(input, weights, bias, Conv1DConfig2))[0];
    }

    public INDArray conv1d(INDArray input, INDArray weights, Conv1DConfig Conv1DConfig2) {
        NDValidation.validateNumerical("conv1d", "input", input);
        NDValidation.validateNumerical("conv1d", "weights", weights);
        return Nd4j.exec(new Conv1D(input, weights, null, Conv1DConfig2))[0];
    }

    public INDArray conv2d(INDArray layerInput, INDArray weights, INDArray bias, Conv2DConfig Conv2DConfig2) {
        NDValidation.validateNumerical("conv2d", "layerInput", layerInput);
        NDValidation.validateNumerical("conv2d", "weights", weights);
        NDValidation.validateNumerical("conv2d", "bias", bias);
        return Nd4j.exec(new Conv2D(layerInput, weights, bias, Conv2DConfig2))[0];
    }

    public INDArray conv2d(INDArray layerInput, INDArray weights, Conv2DConfig Conv2DConfig2) {
        NDValidation.validateNumerical("conv2d", "layerInput", layerInput);
        NDValidation.validateNumerical("conv2d", "weights", weights);
        return Nd4j.exec(new Conv2D(layerInput, weights, null, Conv2DConfig2))[0];
    }

    public INDArray conv3d(INDArray input, INDArray weights, INDArray bias, Conv3DConfig Conv3DConfig2) {
        NDValidation.validateNumerical("conv3d", "input", input);
        NDValidation.validateNumerical("conv3d", "weights", weights);
        NDValidation.validateNumerical("conv3d", "bias", bias);
        return Nd4j.exec(new Conv3D(input, weights, bias, Conv3DConfig2))[0];
    }

    public INDArray conv3d(INDArray input, INDArray weights, Conv3DConfig Conv3DConfig2) {
        NDValidation.validateNumerical("conv3d", "input", input);
        NDValidation.validateNumerical("conv3d", "weights", weights);
        return Nd4j.exec(new Conv3D(input, weights, null, Conv3DConfig2))[0];
    }

    public INDArray deconv2d(INDArray layerInput, INDArray weights, INDArray bias, DeConv2DConfig DeConv2DConfig2) {
        NDValidation.validateNumerical("deconv2d", "layerInput", layerInput);
        NDValidation.validateNumerical("deconv2d", "weights", weights);
        NDValidation.validateNumerical("deconv2d", "bias", bias);
        return Nd4j.exec(new DeConv2D(layerInput, weights, bias, DeConv2DConfig2))[0];
    }

    public INDArray deconv2d(INDArray layerInput, INDArray weights, DeConv2DConfig DeConv2DConfig2) {
        NDValidation.validateNumerical("deconv2d", "layerInput", layerInput);
        NDValidation.validateNumerical("deconv2d", "weights", weights);
        return Nd4j.exec(new DeConv2D(layerInput, weights, null, DeConv2DConfig2))[0];
    }

    public INDArray deconv3d(INDArray input, INDArray weights, INDArray bias, DeConv3DConfig DeConv3DConfig2) {
        NDValidation.validateNumerical("deconv3d", "input", input);
        NDValidation.validateNumerical("deconv3d", "weights", weights);
        NDValidation.validateNumerical("deconv3d", "bias", bias);
        return Nd4j.exec(new DeConv3D(input, weights, bias, DeConv3DConfig2))[0];
    }

    public INDArray deconv3d(INDArray input, INDArray weights, DeConv3DConfig DeConv3DConfig2) {
        NDValidation.validateNumerical("deconv3d", "input", input);
        NDValidation.validateNumerical("deconv3d", "weights", weights);
        return Nd4j.exec(new DeConv3D(input, weights, null, DeConv3DConfig2))[0];
    }

    public INDArray depthToSpace(INDArray x, int blockSize, DataFormat dataFormat) {
        NDValidation.validateNumerical("depthToSpace", "x", x);
        return Nd4j.exec(new DepthToSpace(x, blockSize, dataFormat))[0];
    }

    public INDArray depthWiseConv2d(INDArray layerInput, INDArray depthWeights, INDArray bias, Conv2DConfig Conv2DConfig2) {
        NDValidation.validateNumerical("depthWiseConv2d", "layerInput", layerInput);
        NDValidation.validateNumerical("depthWiseConv2d", "depthWeights", depthWeights);
        NDValidation.validateNumerical("depthWiseConv2d", "bias", bias);
        return Nd4j.exec(new DepthwiseConv2D(layerInput, depthWeights, bias, Conv2DConfig2))[0];
    }

    public INDArray depthWiseConv2d(INDArray layerInput, INDArray depthWeights, Conv2DConfig Conv2DConfig2) {
        NDValidation.validateNumerical("depthWiseConv2d", "layerInput", layerInput);
        NDValidation.validateNumerical("depthWiseConv2d", "depthWeights", depthWeights);
        return Nd4j.exec(new DepthwiseConv2D(layerInput, depthWeights, null, Conv2DConfig2))[0];
    }

    public INDArray dilation2D(INDArray df, INDArray weights, int[] strides, int[] rates, boolean isSameMode) {
        NDValidation.validateNumerical("dilation2D", "df", df);
        NDValidation.validateNumerical("dilation2D", "weights", weights);
        Preconditions.checkArgument(strides.length == 2, "strides has incorrect size/length. Expected: strides.length == 2, got %s", strides.length);
        Preconditions.checkArgument(rates.length == 2, "rates has incorrect size/length. Expected: rates.length == 2, got %s", rates.length);
        return Nd4j.exec(new Dilation2D(df, weights, strides, rates, isSameMode))[0];
    }

    public INDArray extractImagePatches(INDArray input, int kH, int kW, int sH, int sW, int rH, int rW, boolean sameMode) {
        NDValidation.validateNumerical("extractImagePatches", "input", input);
        return Nd4j.exec(new ExtractImagePatches(input, kH, kW, sH, sW, rH, rW, sameMode))[0];
    }

    public INDArray im2Col(INDArray in, Conv2DConfig Conv2DConfig2) {
        NDValidation.validateNumerical("im2Col", "in", in);
        return Nd4j.exec(new Im2col(in, Conv2DConfig2))[0];
    }

    public INDArray localResponseNormalization(INDArray input, LocalResponseNormalizationConfig LocalResponseNormalizationConfig2) {
        NDValidation.validateNumerical("localResponseNormalization", "input", input);
        return Nd4j.exec(new LocalResponseNormalization(input, LocalResponseNormalizationConfig2))[0];
    }

    public INDArray[] maxPoolWithArgmax(INDArray input, Pooling2DConfig Pooling2DConfig2) {
        NDValidation.validateNumerical("maxPoolWithArgmax", "input", input);
        return Nd4j.exec(new MaxPoolWithArgmax(input, Pooling2DConfig2));
    }

    public INDArray maxPooling2d(INDArray input, Pooling2DConfig Pooling2DConfig2) {
        NDValidation.validateNumerical("maxPooling2d", "input", input);
        return Nd4j.exec(new MaxPooling2D(input, Pooling2DConfig2))[0];
    }

    public INDArray maxPooling3d(INDArray input, Pooling3DConfig Pooling3DConfig2) {
        NDValidation.validateNumerical("maxPooling3d", "input", input);
        return Nd4j.exec(new MaxPooling3D(input, Pooling3DConfig2))[0];
    }

    public INDArray separableConv2d(INDArray layerInput, INDArray depthWeights, INDArray pointWeights, INDArray bias, Conv2DConfig Conv2DConfig2) {
        NDValidation.validateNumerical("separableConv2d", "layerInput", layerInput);
        NDValidation.validateNumerical("separableConv2d", "depthWeights", depthWeights);
        NDValidation.validateNumerical("separableConv2d", "pointWeights", pointWeights);
        NDValidation.validateNumerical("separableConv2d", "bias", bias);
        return Nd4j.exec(new SConv2D(layerInput, depthWeights, pointWeights, bias, Conv2DConfig2))[0];
    }

    public INDArray separableConv2d(INDArray layerInput, INDArray depthWeights, INDArray pointWeights, Conv2DConfig Conv2DConfig2) {
        NDValidation.validateNumerical("separableConv2d", "layerInput", layerInput);
        NDValidation.validateNumerical("separableConv2d", "depthWeights", depthWeights);
        NDValidation.validateNumerical("separableConv2d", "pointWeights", pointWeights);
        return Nd4j.exec(new SConv2D(layerInput, depthWeights, pointWeights, null, Conv2DConfig2))[0];
    }

    public INDArray spaceToBatch(INDArray x, int[] blocks, int[] paddingTop, int ... paddingBottom) {
        NDValidation.validateNumerical("spaceToBatch", "x", x);
        Preconditions.checkArgument(blocks.length == 2, "blocks has incorrect size/length. Expected: blocks.length == 2, got %s", blocks.length);
        Preconditions.checkArgument(paddingTop.length == 2, "paddingTop has incorrect size/length. Expected: paddingTop.length == 2, got %s", paddingTop.length);
        Preconditions.checkArgument(paddingBottom.length == 2, "paddingBottom has incorrect size/length. Expected: paddingBottom.length == 2, got %s", paddingBottom.length);
        return Nd4j.exec(new SpaceToBatch(x, blocks, paddingTop, paddingBottom))[0];
    }

    public INDArray spaceToDepth(INDArray x, int blockSize, DataFormat dataFormat) {
        NDValidation.validateNumerical("spaceToDepth", "x", x);
        return Nd4j.exec(new SpaceToDepth(x, blockSize, dataFormat))[0];
    }

    public INDArray upsampling2d(INDArray input, int scale) {
        NDValidation.validateNumerical("upsampling2d", "input", input);
        return Nd4j.exec(new Upsampling2d(input, scale))[0];
    }

    public INDArray upsampling2d(INDArray input, int scaleH, int scaleW, boolean nchw) {
        NDValidation.validateNumerical("upsampling2d", "input", input);
        return Nd4j.exec(new Upsampling2d(input, scaleH, scaleW, nchw))[0];
    }

    public INDArray upsampling3d(INDArray input, boolean ncdhw, int scaleD, int scaleH, int scaleW) {
        NDValidation.validateNumerical("upsampling3d", "input", input);
        return Nd4j.exec(new Upsampling3d(input, ncdhw, scaleD, scaleH, scaleW))[0];
    }
}

