/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class DataTypeValidation {
    public static void assertDouble(INDArray ... d) {
        for (INDArray d1 : d) {
            DataTypeValidation.assertDouble(d1);
        }
    }

    public static void assertFloat(INDArray ... d2) {
        for (INDArray d3 : d2) {
            DataTypeValidation.assertFloat(d3);
        }
    }

    public static void assertDouble(INDArray d) {
        if (d.data().dataType() != DataType.DOUBLE) {
            throw new IllegalStateException("Given ndarray does not have data opType double");
        }
    }

    public static void assertFloat(INDArray d2) {
        if (d2.data().dataType() != DataType.FLOAT) {
            throw new IllegalStateException("Given ndarray does not have data opType float");
        }
    }

    public static void assertSameDataType(INDArray ... indArrays) {
        if (indArrays == null || indArrays.length < 2) {
            return;
        }
        DataType type = indArrays[0].data().dataType();
        for (int i = 1; i < indArrays.length; ++i) {
            DataType t = indArrays[i].data().dataType();
            Preconditions.checkState(t == type, "Data types must be same: got %s and %s", (Object)type, (Object)t);
        }
    }
}

