/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.BaseDynamicTransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.bp.MergeAddBp;

public class MergeAddOp
extends BaseDynamicTransformOp {
    public MergeAddOp(SameDiff sameDiff, SDVariable[] args, boolean inPlace) {
        super(sameDiff, args, inPlace);
    }

    public MergeAddOp(SameDiff sameDiff, SDVariable[] args) {
        this(sameDiff, args, false);
    }

    public MergeAddOp(INDArray ... inputs) {
        this(inputs, (INDArray[])null);
        if (inputs == null) {
            throw new NullPointerException("inputs is marked non-null but is null");
        }
    }

    public MergeAddOp(INDArray[] inputs, INDArray[] outputs) {
        super(inputs, outputs);
    }

    @Override
    public String opName() {
        return "mergeadd";
    }

    @Override
    public String onnxName() {
        return "mergeadd";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"add_n", "AccumulateNV2"};
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        return Arrays.asList(new MergeAddBp(this.sameDiff, this.args(), i_v.get(0)).outputVariables());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        DataType first = dataTypes.get(0);
        for (int i = 1; i < dataTypes.size(); ++i) {
            Preconditions.checkState(first == dataTypes.get(i), "Expected all input datatypes to be the same: first input is %s, input %s is %s", (Object)first, (Object)i, (Object)dataTypes.get(i));
        }
        return Collections.singletonList(first);
    }

    public MergeAddOp() {
    }
}

