/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public class MatrixSetDiag
extends DynamicCustomOp {
    public MatrixSetDiag(SameDiff sameDiff, SDVariable in, SDVariable diag, boolean inPlace) {
        super(null, sameDiff, new SDVariable[]{in, diag}, inPlace);
    }

    public MatrixSetDiag(SameDiff sameDiff, SDVariable in, SDVariable diag) {
        this(sameDiff, in, diag, false);
    }

    public MatrixSetDiag(@NonNull INDArray in, @NonNull INDArray diag) {
        super(new INDArray[]{in, diag}, null);
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (diag == null) {
            throw new NullPointerException("diag is marked non-null but is null");
        }
    }

    public MatrixSetDiag() {
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"MatrixSetDiag", "BatchMatrixSetDiag"};
    }

    @Override
    public String opName() {
        return "matrix_set_diag";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable grad = i_v.get(0);
        SDVariable in1Grad = this.sameDiff.math.setDiag(grad, this.sameDiff.zerosLike(this.arg(1)));
        SDVariable in2Grad = this.sameDiff.math.diagPart(grad);
        return Arrays.asList(in1Grad, in2Grad);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null && dataTypes.size() == 2, "Expected exactly 2 input datatypes for %s, got %s", this.getClass(), dataTypes);
        Preconditions.checkState(dataTypes.get(0) == dataTypes.get(1), "Input datatypes must be same type, got %s", dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

