/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.BaseDynamicTransformOp;

public class InvertPermutation
extends BaseDynamicTransformOp {
    public InvertPermutation(SameDiff sameDiff, SDVariable input) {
        this(sameDiff, input, false);
    }

    public InvertPermutation(SameDiff sameDiff, SDVariable input, boolean inPlace) {
        super(sameDiff, new SDVariable[]{input}, inPlace);
    }

    public InvertPermutation(INDArray input) {
        this.addInputArgument(input);
    }

    @Override
    public String opName() {
        return "invert_permutation";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx name found for shape " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "InvertPermutation";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        SDVariable gradient = grad.get(0);
        SDVariable invertedGradient = this.sameDiff.invertPermutation(gradient);
        return Collections.singletonList(invertedGradient);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null && dataTypes.size() == 1, "Expected exactly 1 input datatype for %s, got %s", this.getClass(), dataTypes);
        return dataTypes;
    }

    public InvertPermutation() {
    }
}

