/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.BaseDynamicTransformOp;

public class ATan2
extends BaseDynamicTransformOp {
    public ATan2(SameDiff sameDiff, SDVariable y, SDVariable x) {
        super(sameDiff, new SDVariable[]{y, x}, false);
    }

    public ATan2(INDArray x, INDArray y) {
        this(x, y, null);
    }

    public ATan2(INDArray x, INDArray y, INDArray z) {
        super(new INDArray[]{x, y}, ATan2.wrapOrNull(z));
    }

    public ATan2() {
    }

    @Override
    public String opName() {
        return "tf_atan2";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "Atan2";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable y = this.larg();
        SDVariable x = this.rarg();
        SDVariable xGrad = this.sameDiff.math.neg(y.div(x.pow(2.0).add(y.pow(2.0)))).mul(i_v.get(0));
        SDVariable yGrad = x.div(x.pow(2.0).add(y.pow(2.0))).mul(i_v.get(0));
        return Arrays.asList(yGrad, xGrad);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes != null && dataTypes.size() == 2, "Expected exactly 2 input datatypes for %s, got %s", this.getClass(), dataTypes);
        Preconditions.checkState(dataTypes.get(0) == dataTypes.get(1), "Input datatypes must be same type: got %s", dataTypes);
        return Collections.singletonList(dataTypes.get(0));
    }
}

