/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Create
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Create.class);
    protected boolean initialize = false;
    protected char order = (char)99;
    protected DataType outputType = DataType.FLOAT;

    public Create() {
    }

    public Create(String name, SameDiff sameDiff, SDVariable input, boolean initialize) {
        this(name, sameDiff, input, 'c', initialize, input.dataType());
    }

    public Create(String name, SameDiff sameDiff, SDVariable input, char order, boolean initialize, DataType dataType) {
        super(name, sameDiff, new SDVariable[]{input}, false);
        this.outputType = dataType;
        this.initialize = initialize;
        this.order = order;
        this.addArgs();
    }

    public Create(INDArray shape, DataType dataType) {
        this(shape, 'c', false, dataType);
    }

    public Create(INDArray shape, boolean initialize, DataType dataType) {
        this(shape, 'c', initialize, dataType);
    }

    public Create(@NonNull INDArray shape, char order, boolean initialize, DataType dataType) {
        super(new INDArray[]{shape}, new INDArray[0]);
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        this.order = order;
        this.initialize = initialize;
        this.outputType = dataType;
        this.addArgs();
    }

    protected void addArgs() {
        this.addBArgument(this.initialize);
        this.addIArgument(new int[]{this.order, this.outputType.toInt()});
    }

    @Override
    public String opName() {
        return "create";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No op found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "Empty";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (attributesForNode.containsKey("dtype")) {
            this.outputType = TFGraphMapper.convertType(attributesForNode.get("dtype").getType());
        }
        if (attributesForNode.containsKey("init")) {
            this.initialize = attributesForNode.get("init").getB();
        }
        this.order = (char)99;
        this.addArgs();
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable ret = this.sameDiff.zerosLike(this.outputVariables()[0]);
        return Arrays.asList(ret);
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState(dataTypes.size() == 1, "Expected list with exactly 1 datatype for %s, got %s", this.getClass(), dataTypes);
        if (this.outputType != null) {
            return Collections.singletonList(this.outputType);
        }
        return dataTypes;
    }
}

