/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce.floating;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseReduceFloatOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.reduce.bp.SumBp;

public class Entropy
extends BaseReduceFloatOp {
    public Entropy(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public Entropy() {
    }

    public Entropy(INDArray x, INDArray z, int ... dimensions) {
        super(x, null, z, dimensions);
    }

    public Entropy(INDArray x, int ... dimensions) {
        super(x, dimensions);
    }

    @Override
    public int opNum() {
        return 8;
    }

    @Override
    public String opName() {
        return "entropy";
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.REDUCE_FLOAT;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Entropy.grad(this.sameDiff, this.arg(), f1.get(0), this.dimensions);
    }

    public static List<SDVariable> grad(SameDiff sd, SDVariable arg, SDVariable grad, int[] dimensions) {
        SDVariable logx = sd.math.log(arg);
        SDVariable xLogX = arg.mul(logx);
        SDVariable sumBp = new SumBp(sd, xLogX, grad.neg(), false, dimensions).outputVariable();
        return Collections.singletonList(sumBp.mul(logx.add(1.0)));
    }
}

