/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.loss;

import java.util.List;
import org.nd4j.autodiff.loss.LossReduce;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.loss.BaseLoss;
import org.nd4j.linalg.api.ops.impl.loss.bp.HuberLossBp;

public class HuberLoss
extends BaseLoss {
    private double delta;

    public HuberLoss(SameDiff sameDiff, LossReduce lossReduce, SDVariable predictions, SDVariable weights, SDVariable labels, double delta) {
        super(sameDiff, lossReduce, predictions, weights, labels);
        Preconditions.checkState(delta >= 0.0, "Delta must be >= 0.0. Got: %s", delta);
        this.delta = delta;
        this.tArguments.add(delta);
    }

    public HuberLoss(SameDiff sameDiff, SDVariable labels, SDVariable predictions, SDVariable weights, LossReduce lossReduce, double delta) {
        this(sameDiff, lossReduce, predictions, weights, labels, delta);
    }

    public HuberLoss(INDArray labels, INDArray predictions, INDArray weights, LossReduce lossReduce, double delta) {
        super(lossReduce, predictions, weights, labels);
        this.delta = delta;
        this.tArguments.add(delta);
    }

    public HuberLoss() {
    }

    @Override
    public String opName() {
        return "huber_loss";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return new HuberLossBp(this.sameDiff, this.lossReduce, this.arg(0), this.arg(1), this.arg(2), this.delta).outputs();
    }
}

