/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.weights;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.weights.RNNWeights;

public class LSTMLayerWeights
extends RNNWeights {
    private SDVariable weights;
    private INDArray iWeights;
    private SDVariable rWeights;
    private INDArray irWeights;
    private SDVariable peepholeWeights;
    private INDArray iPeepholeWeights;
    private SDVariable bias;
    private INDArray iBias;

    @Override
    public SDVariable[] args() {
        return LSTMLayerWeights.filterNonNull(this.weights, this.rWeights, this.peepholeWeights, this.bias);
    }

    @Override
    public INDArray[] arrayArgs() {
        return LSTMLayerWeights.filterNonNull(this.iWeights, this.irWeights, this.iPeepholeWeights, this.iBias);
    }

    @Override
    public SDVariable[] argsWithInputs(SDVariable ... inputs) {
        Preconditions.checkArgument(inputs.length == 4, "Expected 4 inputs, got %s", inputs.length);
        return ArrayUtil.filterNull(inputs[0], this.weights, this.rWeights, this.bias, inputs[1], inputs[2], inputs[3], this.peepholeWeights);
    }

    @Override
    public INDArray[] argsWithInputs(INDArray ... inputs) {
        Preconditions.checkArgument(inputs.length == 4, "Expected 4 inputs, got %s", inputs.length);
        return ArrayUtil.filterNull(inputs[0], this.iWeights, this.irWeights, this.iBias, inputs[1], inputs[2], inputs[3], this.iPeepholeWeights);
    }

    public boolean hasBias() {
        return this.bias != null || this.iBias != null;
    }

    public boolean hasPH() {
        return this.peepholeWeights != null || this.iPeepholeWeights != null;
    }

    LSTMLayerWeights(SDVariable weights, INDArray iWeights, SDVariable rWeights, INDArray irWeights, SDVariable peepholeWeights, INDArray iPeepholeWeights, SDVariable bias, INDArray iBias) {
        this.weights = weights;
        this.iWeights = iWeights;
        this.rWeights = rWeights;
        this.irWeights = irWeights;
        this.peepholeWeights = peepholeWeights;
        this.iPeepholeWeights = iPeepholeWeights;
        this.bias = bias;
        this.iBias = iBias;
    }

    public static LSTMLayerWeightsBuilder builder() {
        return new LSTMLayerWeightsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LSTMLayerWeights)) {
            return false;
        }
        LSTMLayerWeights other = (LSTMLayerWeights)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SDVariable this$weights = this.getWeights();
        SDVariable other$weights = other.getWeights();
        if (this$weights == null ? other$weights != null : !((Object)this$weights).equals(other$weights)) {
            return false;
        }
        INDArray this$iWeights = this.getIWeights();
        INDArray other$iWeights = other.getIWeights();
        if (this$iWeights == null ? other$iWeights != null : !this$iWeights.equals(other$iWeights)) {
            return false;
        }
        SDVariable this$rWeights = this.getRWeights();
        SDVariable other$rWeights = other.getRWeights();
        if (this$rWeights == null ? other$rWeights != null : !((Object)this$rWeights).equals(other$rWeights)) {
            return false;
        }
        INDArray this$irWeights = this.getIrWeights();
        INDArray other$irWeights = other.getIrWeights();
        if (this$irWeights == null ? other$irWeights != null : !this$irWeights.equals(other$irWeights)) {
            return false;
        }
        SDVariable this$peepholeWeights = this.getPeepholeWeights();
        SDVariable other$peepholeWeights = other.getPeepholeWeights();
        if (this$peepholeWeights == null ? other$peepholeWeights != null : !((Object)this$peepholeWeights).equals(other$peepholeWeights)) {
            return false;
        }
        INDArray this$iPeepholeWeights = this.getIPeepholeWeights();
        INDArray other$iPeepholeWeights = other.getIPeepholeWeights();
        if (this$iPeepholeWeights == null ? other$iPeepholeWeights != null : !this$iPeepholeWeights.equals(other$iPeepholeWeights)) {
            return false;
        }
        SDVariable this$bias = this.getBias();
        SDVariable other$bias = other.getBias();
        if (this$bias == null ? other$bias != null : !((Object)this$bias).equals(other$bias)) {
            return false;
        }
        INDArray this$iBias = this.getIBias();
        INDArray other$iBias = other.getIBias();
        return !(this$iBias == null ? other$iBias != null : !this$iBias.equals(other$iBias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LSTMLayerWeights;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SDVariable $weights = this.getWeights();
        result = result * 59 + ($weights == null ? 43 : ((Object)$weights).hashCode());
        INDArray $iWeights = this.getIWeights();
        result = result * 59 + ($iWeights == null ? 43 : $iWeights.hashCode());
        SDVariable $rWeights = this.getRWeights();
        result = result * 59 + ($rWeights == null ? 43 : ((Object)$rWeights).hashCode());
        INDArray $irWeights = this.getIrWeights();
        result = result * 59 + ($irWeights == null ? 43 : $irWeights.hashCode());
        SDVariable $peepholeWeights = this.getPeepholeWeights();
        result = result * 59 + ($peepholeWeights == null ? 43 : ((Object)$peepholeWeights).hashCode());
        INDArray $iPeepholeWeights = this.getIPeepholeWeights();
        result = result * 59 + ($iPeepholeWeights == null ? 43 : $iPeepholeWeights.hashCode());
        SDVariable $bias = this.getBias();
        result = result * 59 + ($bias == null ? 43 : ((Object)$bias).hashCode());
        INDArray $iBias = this.getIBias();
        result = result * 59 + ($iBias == null ? 43 : $iBias.hashCode());
        return result;
    }

    public SDVariable getWeights() {
        return this.weights;
    }

    public INDArray getIWeights() {
        return this.iWeights;
    }

    public SDVariable getRWeights() {
        return this.rWeights;
    }

    public INDArray getIrWeights() {
        return this.irWeights;
    }

    public SDVariable getPeepholeWeights() {
        return this.peepholeWeights;
    }

    public INDArray getIPeepholeWeights() {
        return this.iPeepholeWeights;
    }

    public SDVariable getBias() {
        return this.bias;
    }

    public INDArray getIBias() {
        return this.iBias;
    }

    public void setWeights(SDVariable weights) {
        this.weights = weights;
    }

    public void setIWeights(INDArray iWeights) {
        this.iWeights = iWeights;
    }

    public void setRWeights(SDVariable rWeights) {
        this.rWeights = rWeights;
    }

    public void setIrWeights(INDArray irWeights) {
        this.irWeights = irWeights;
    }

    public void setPeepholeWeights(SDVariable peepholeWeights) {
        this.peepholeWeights = peepholeWeights;
    }

    public void setIPeepholeWeights(INDArray iPeepholeWeights) {
        this.iPeepholeWeights = iPeepholeWeights;
    }

    public void setBias(SDVariable bias) {
        this.bias = bias;
    }

    public void setIBias(INDArray iBias) {
        this.iBias = iBias;
    }

    public String toString() {
        return "LSTMLayerWeights(weights=" + this.getWeights() + ", iWeights=" + this.getIWeights() + ", rWeights=" + this.getRWeights() + ", irWeights=" + this.getIrWeights() + ", peepholeWeights=" + this.getPeepholeWeights() + ", iPeepholeWeights=" + this.getIPeepholeWeights() + ", bias=" + this.getBias() + ", iBias=" + this.getIBias() + ")";
    }

    public static class LSTMLayerWeightsBuilder {
        private SDVariable weights;
        private INDArray iWeights;
        private SDVariable rWeights;
        private INDArray irWeights;
        private SDVariable peepholeWeights;
        private INDArray iPeepholeWeights;
        private SDVariable bias;
        private INDArray iBias;

        LSTMLayerWeightsBuilder() {
        }

        public LSTMLayerWeightsBuilder weights(SDVariable weights) {
            this.weights = weights;
            return this;
        }

        public LSTMLayerWeightsBuilder iWeights(INDArray iWeights) {
            this.iWeights = iWeights;
            return this;
        }

        public LSTMLayerWeightsBuilder rWeights(SDVariable rWeights) {
            this.rWeights = rWeights;
            return this;
        }

        public LSTMLayerWeightsBuilder irWeights(INDArray irWeights) {
            this.irWeights = irWeights;
            return this;
        }

        public LSTMLayerWeightsBuilder peepholeWeights(SDVariable peepholeWeights) {
            this.peepholeWeights = peepholeWeights;
            return this;
        }

        public LSTMLayerWeightsBuilder iPeepholeWeights(INDArray iPeepholeWeights) {
            this.iPeepholeWeights = iPeepholeWeights;
            return this;
        }

        public LSTMLayerWeightsBuilder bias(SDVariable bias) {
            this.bias = bias;
            return this;
        }

        public LSTMLayerWeightsBuilder iBias(INDArray iBias) {
            this.iBias = iBias;
            return this;
        }

        public LSTMLayerWeights build() {
            return new LSTMLayerWeights(this.weights, this.iWeights, this.rWeights, this.irWeights, this.peepholeWeights, this.iPeepholeWeights, this.bias, this.iBias);
        }

        public String toString() {
            return "LSTMLayerWeights.LSTMLayerWeightsBuilder(weights=" + this.weights + ", iWeights=" + this.iWeights + ", rWeights=" + this.rWeights + ", irWeights=" + this.irWeights + ", peepholeWeights=" + this.peepholeWeights + ", iPeepholeWeights=" + this.iPeepholeWeights + ", bias=" + this.bias + ", iBias=" + this.iBias + ")";
        }
    }
}

