/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upsampling2dDerivative
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Upsampling2dDerivative.class);
    protected boolean nchw;
    protected int scaleH;
    protected int scaleW;

    public Upsampling2dDerivative() {
    }

    public Upsampling2dDerivative(SameDiff sameDiff, SDVariable input, SDVariable gradient, boolean nchw, int scaleH, int scaleW) {
        super(null, sameDiff, new SDVariable[]{input, gradient});
        this.nchw = nchw;
        this.scaleH = scaleH;
        this.scaleW = scaleW;
        this.addIArgument(scaleH);
        this.addIArgument(scaleW);
        this.addIArgument(nchw ? 1 : 0);
    }

    @Override
    public String opName() {
        return "upsampling2d_bp";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Unable to take derivative of derivative.");
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == 2, "Expected 2 input data type for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

