/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pooling2DDerivative
extends Pooling2D {
    private static final Logger log = LoggerFactory.getLogger(Pooling2DDerivative.class);

    public Pooling2DDerivative(SameDiff sameDiff, SDVariable[] inputs, Pooling2DConfig config) {
        super(sameDiff, inputs, config);
    }

    public Pooling2DDerivative(@NonNull INDArray input, @NonNull INDArray grad, INDArray output, Pooling2DConfig config) {
        super(new INDArray[]{input, grad}, Pooling2DDerivative.wrapOrNull(output), config);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (grad == null) {
            throw new NullPointerException("grad is marked non-null but is null");
        }
    }

    public Pooling2DDerivative() {
    }

    @Override
    public String opName() {
        return super.opName() + "_bp";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Unable to take derivative of derivative.");
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == 2, "Expected 2 input data types for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static Pooling2DDerivativeBuilder derivativeBuilder() {
        return new Pooling2DDerivativeBuilder();
    }

    public static class Pooling2DDerivativeBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputs;
        private Pooling2DConfig config;

        Pooling2DDerivativeBuilder() {
        }

        public Pooling2DDerivativeBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Pooling2DDerivativeBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public Pooling2DDerivativeBuilder config(Pooling2DConfig config) {
            this.config = config;
            return this;
        }

        public Pooling2DDerivative build() {
            return new Pooling2DDerivative(this.sameDiff, this.inputs, this.config);
        }

        public String toString() {
            return "Pooling2DDerivative.Pooling2DDerivativeBuilder(sameDiff=" + this.sameDiff + ", inputs=" + Arrays.deepToString(this.inputs) + ", config=" + this.config + ")";
        }
    }
}

