/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv3DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeConv3DDerivative
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(DeConv3DDerivative.class);
    protected DeConv3DConfig config;

    public DeConv3DDerivative() {
    }

    public DeConv3DDerivative(SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, SDVariable grad, DeConv3DConfig config) {
        super(sameDiff, DeConv3DDerivative.toArr(input, weights, bias, grad));
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        this.config = config;
        this.addArgs();
    }

    private static SDVariable[] toArr(SDVariable input, SDVariable weights, SDVariable bias, SDVariable grad) {
        if (bias != null) {
            return new SDVariable[]{input, weights, bias, grad};
        }
        return new SDVariable[]{input, weights, grad};
    }

    @Override
    public String opName() {
        return "deconv3d_bp";
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = DeConv3DConfig.builder().kD((Long)this.iArguments.get(0)).kH((Long)this.iArguments.get(1)).kW((Long)this.iArguments.get(2)).sD((Long)this.iArguments.get(3)).sH((Long)this.iArguments.get(4)).sW((Long)this.iArguments.get(5)).pD((Long)this.iArguments.get(6)).pH((Long)this.iArguments.get(7)).pW((Long)this.iArguments.get(8)).dD((Long)this.iArguments.get(9)).dH((Long)this.iArguments.get(10)).dW((Long)this.iArguments.get(11)).isSameMode((Long)this.iArguments.get(12) == 1L).dataFormat((Long)this.iArguments.get(13) == 1L ? "NDHWC" : "NCDHW").build();
        }
        return this.config.toProperties();
    }

    private void addArgs() {
        this.addIArgument(this.config.getKD());
        this.addIArgument(this.config.getKH());
        this.addIArgument(this.config.getKW());
        this.addIArgument(this.config.getSD());
        this.addIArgument(this.config.getSH());
        this.addIArgument(this.config.getSW());
        this.addIArgument(this.config.getPD());
        this.addIArgument(this.config.getPH());
        this.addIArgument(this.config.getPW());
        this.addIArgument(this.config.getDD());
        this.addIArgument(this.config.getDH());
        this.addIArgument(this.config.getDW());
        this.addIArgument(ArrayUtil.fromBoolean(this.config.isSameMode()));
        this.addIArgument(this.config.getDataFormat().equalsIgnoreCase("NCDHW") ? 0 : 1);
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No op name found for backwards.");
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No op name found for backwards");
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Gradient of DeConv3DDerivative not supported.");
    }

    @Override
    public int getNumOutputs() {
        SDVariable[] args = this.args();
        return args.length - 1;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        ArrayList<DataType> out = new ArrayList<DataType>(n - 1);
        for (int i = 0; i < n - 1; ++i) {
            out.add(inputDataTypes.get(i));
        }
        return out;
    }
}

