/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.impl.layers.convolution.DeConv2D;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeConv2DDerivative
extends DeConv2D {
    private static final Logger log = LoggerFactory.getLogger(DeConv2DDerivative.class);

    public DeConv2DDerivative() {
    }

    public DeConv2DDerivative(SameDiff sameDiff, SDVariable[] inputs, DeConv2DConfig config) {
        super(sameDiff, inputs, config);
    }

    @Override
    public String opName() {
        return "deconv2d_bp";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No op name found for backwards.");
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No op name found for backwards");
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException("Unable to take derivative of derivative.");
    }

    @Override
    public int getNumOutputs() {
        SDVariable[] args = this.args();
        return args.length - 1;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        ArrayList<DataType> out = new ArrayList<DataType>(n - 1);
        for (int i = 0; i < n - 1; ++i) {
            out.add(inputDataTypes.get(i));
        }
        return out;
    }

    public static DeConv2DDerivativeBuilder derivativeBuilder() {
        return new DeConv2DDerivativeBuilder();
    }

    public static class DeConv2DDerivativeBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputs;
        private DeConv2DConfig config;

        DeConv2DDerivativeBuilder() {
        }

        public DeConv2DDerivativeBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public DeConv2DDerivativeBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public DeConv2DDerivativeBuilder config(DeConv2DConfig config) {
            this.config = config;
            return this;
        }

        public DeConv2DDerivative build() {
            return new DeConv2DDerivative(this.sameDiff, this.inputs, this.config);
        }

        public String toString() {
            return "DeConv2DDerivative.DeConv2DDerivativeBuilder(sameDiff=" + this.sameDiff + ", inputs=" + Arrays.deepToString(this.inputs) + ", config=" + this.config + ")";
        }
    }
}

