/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv1DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.PaddingMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conv1DDerivative
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Conv1DDerivative.class);
    protected Conv1DConfig config;
    private static final String INVALID_CONFIGURATION = "Invalid Conv1D configuration : s = %s p = %s ";

    public Conv1DDerivative(@NonNull SameDiff sameDiff, @NonNull SDVariable[] inputs, @NonNull Conv1DConfig config) {
        super(sameDiff, inputs);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (inputs == null) {
            throw new NullPointerException("inputs is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.initConfig(config);
    }

    public Conv1DDerivative(@NonNull SameDiff sd, @NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, SDVariable gradOut, @NonNull Conv1DConfig config) {
        this(sd, Conv1DDerivative.wrapFilterNull(input, weights, bias, gradOut), config);
        if (sd == null) {
            throw new NullPointerException("sd is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
    }

    public Conv1DDerivative(INDArray[] inputs, INDArray[] outputs, Conv1DConfig config) {
        super(inputs, outputs);
        this.initConfig(config);
    }

    public Conv1DDerivative(@NonNull INDArray input, @NonNull INDArray weights, INDArray bias, @NonNull INDArray gradOut, INDArray output, @NonNull Conv1DConfig config) {
        this(Conv1DDerivative.wrapFilterNull(input, weights, bias, gradOut), Conv1DDerivative.wrapOrNull(output), config);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (gradOut == null) {
            throw new NullPointerException("gradOut is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
    }

    private void initConfig(Conv1DConfig config) {
        this.config = config;
        Preconditions.checkState(config.getS() >= 1L && config.getP() >= 0L, INVALID_CONFIGURATION, config.getS(), config.getP());
        this.addArgs();
    }

    protected void addArgs() {
        if (this.config == null) {
            this.config = Conv1DConfig.builder().build();
        }
        this.addIArgument(this.config.getK(), this.config.getS(), this.config.getP(), this.config.getD(), this.config.getPaddingMode().ordinal(), ArrayUtil.fromBoolean(this.config.isNWC()));
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.config = Conv1DConfig.builder().k((Long)this.iArguments.get(0)).s((Long)this.iArguments.get(1)).p((Long)this.iArguments.get(2)).d((Long)this.iArguments.get(3)).paddingMode(PaddingMode.values()[((Long)this.iArguments.get(4)).intValue()]).dataFormat((Long)this.iArguments.get(5) == 1L ? "NCW" : "NWC").build();
        }
        return this.config.getValue(property);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.config.toProperties();
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public String opName() {
        return "conv1d_bp";
    }

    @Override
    public int getNumOutputs() {
        if (this.args().length == 4) {
            return 3;
        }
        return 2;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return new ArrayList<DataType>(inputDataTypes.subList(0, inputDataTypes.size() - 1));
    }

    public Conv1DConfig getConfig() {
        return this.config;
    }

    public Conv1DDerivative() {
    }
}

