/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.image;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class ExtractImagePatches
extends DynamicCustomOp {
    private int[] kSizes;
    private int[] strides;
    private int[] rates;
    private boolean isSameMode;

    public ExtractImagePatches() {
    }

    public ExtractImagePatches(@NonNull SameDiff samediff, @NonNull SDVariable input, int kH, int kW, int sH, int sW, int rH, int rW, boolean sameMode) {
        this(samediff, input, new int[]{kH, kW}, new int[]{sH, sW}, new int[]{rH, rW}, sameMode);
        if (samediff == null) {
            throw new NullPointerException("samediff is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
    }

    public ExtractImagePatches(@NonNull SameDiff samediff, @NonNull SDVariable input, @NonNull int[] kSizes, @NonNull int[] strides, @NonNull int[] rates, boolean sameMode) {
        super(samediff, input);
        if (samediff == null) {
            throw new NullPointerException("samediff is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (kSizes == null) {
            throw new NullPointerException("kSizes is marked non-null but is null");
        }
        if (strides == null) {
            throw new NullPointerException("strides is marked non-null but is null");
        }
        if (rates == null) {
            throw new NullPointerException("rates is marked non-null but is null");
        }
        Preconditions.checkState(kSizes.length == 2, "Expected exactly 2 kernel sizes, got %s", (Object)kSizes);
        Preconditions.checkState(strides.length == 2, "Expected exactly 2 strides, got %s", (Object)strides);
        Preconditions.checkState(rates.length == 2, "Expected exactly 2 rate values, got %s", (Object)rates);
        this.kSizes = kSizes;
        this.strides = strides;
        this.rates = rates;
        this.isSameMode = sameMode;
        this.addArgs();
    }

    public ExtractImagePatches(@NonNull INDArray input, @NonNull int[] kSizes, @NonNull int[] strides, @NonNull int[] rates, boolean sameMode) {
        super(new INDArray[]{input}, null);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (kSizes == null) {
            throw new NullPointerException("kSizes is marked non-null but is null");
        }
        if (strides == null) {
            throw new NullPointerException("strides is marked non-null but is null");
        }
        if (rates == null) {
            throw new NullPointerException("rates is marked non-null but is null");
        }
        Preconditions.checkState(kSizes.length == 2, "Expected exactly 2 kernel sizes, got %s", (Object)kSizes);
        Preconditions.checkState(strides.length == 2, "Expected exactly 2 strides, got %s", (Object)strides);
        Preconditions.checkState(rates.length == 2, "Expected exactly 2 rate values, got %s", (Object)rates);
        this.kSizes = kSizes;
        this.strides = strides;
        this.rates = rates;
        this.isSameMode = sameMode;
        this.addArgs();
    }

    public ExtractImagePatches(INDArray input, int kH, int kW, int sH, int sW, int rH, int rW, boolean sameMode) {
        this(input, new int[]{kH, kW}, new int[]{sH, sW}, new int[]{rH, rW}, sameMode);
    }

    @Override
    public String opName() {
        return "extract_image_patches";
    }

    @Override
    public String tensorflowName() {
        return "ExtractImagePatches";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        this.kSizes = ExtractImagePatches.parseIntList(attributesForNode.get("ksizes").getList());
        this.strides = ExtractImagePatches.parseIntList(attributesForNode.get("strides").getList());
        this.rates = ExtractImagePatches.parseIntList(attributesForNode.get("rates").getList());
        String s = attributesForNode.get("padding").getS().toStringUtf8();
        this.isSameMode = s.equalsIgnoreCase("SAME");
        this.addArgs();
    }

    protected void addArgs() {
        this.iArguments.clear();
        this.addIArgument(this.kSizes);
        this.addIArgument(this.strides);
        this.addIArgument(this.rates);
        this.addIArgument(this.isSameMode ? 1 : 0);
        this.addIArgument(new int[0]);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumOutputs() {
        return 1;
    }

    private static int[] parseIntList(AttrValue.ListValue ilist) {
        return new int[]{(int)ilist.getI(1), (int)ilist.getI(2)};
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == 1, "Expected exactly 1 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

