/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;

public abstract class BaseAdjustContrast
extends DynamicCustomOp {
    public BaseAdjustContrast() {
    }

    public BaseAdjustContrast(@NonNull INDArray in, double factor, INDArray out) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        Preconditions.checkArgument(in.rank() >= 3, "AdjustContrast: op expects rank of input array to be >= 3, but got %s instead", in.rank());
        this.inputArguments.add(in);
        this.outputArguments.add(out);
        this.addTArgument(factor);
    }

    public BaseAdjustContrast(@NonNull SameDiff sameDiff, @NonNull SDVariable[] vars) {
        super("", sameDiff, vars);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (vars == null) {
            throw new NullPointerException("vars is marked non-null but is null");
        }
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState(inputDataTypes != null && inputDataTypes.size() == n, "Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

