/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.memory.pointers;

import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.nd4j.linalg.api.memory.pointers.ImmortalFloatPointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedPointer
extends Pointer {
    private static final Logger log = LoggerFactory.getLogger(PagedPointer.class);
    private Pointer originalPointer;
    private boolean leaked = false;

    private PagedPointer() {
    }

    public PagedPointer(long address) {
        this.originalPointer = null;
        this.address = address;
        this.capacity = 0L;
        this.limit = 0L;
        this.position = 0L;
    }

    public PagedPointer(Pointer pointer) {
        this.originalPointer = pointer;
        this.address = pointer.address();
        this.capacity = pointer.capacity();
        this.limit = pointer.limit();
        this.position = 0L;
    }

    public PagedPointer(Pointer pointer, long capacity) {
        this.originalPointer = pointer;
        this.address = pointer == null ? 0L : pointer.address();
        this.capacity = capacity;
        this.limit = capacity;
        this.position = 0L;
    }

    public PagedPointer(Pointer pointer, long capacity, long offset) {
        this.address = pointer.address() + offset;
        this.capacity = capacity;
        this.limit = capacity;
        this.position = 0L;
    }

    public PagedPointer withOffset(long offset, long capacity) {
        return new PagedPointer(this, capacity, offset);
    }

    public FloatPointer asFloatPointer() {
        return new ImmortalFloatPointer(this);
    }

    public DoublePointer asDoublePointer() {
        return new DoublePointer(this);
    }

    public IntPointer asIntPointer() {
        return new IntPointer(this);
    }

    public LongPointer asLongPointer() {
        return new LongPointer(this);
    }

    public BytePointer asBytePointer() {
        return new BytePointer(this);
    }

    public ShortPointer asShortPointer() {
        return new ShortPointer(this);
    }

    public BooleanPointer asBoolPointer() {
        return new BooleanPointer(this);
    }

    @Override
    public void deallocate() {
        super.deallocate();
    }

    @Override
    public void deallocate(boolean deallocate) {
        super.deallocate(true);
    }

    public Pointer getOriginalPointer() {
        return this.originalPointer;
    }

    public boolean isLeaked() {
        return this.leaked;
    }

    public void setLeaked(boolean leaked) {
        this.leaked = leaked;
    }
}

