/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.activations.impl;

import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.activations.BaseActivationFunction;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.scalar.LeakyReLU;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.LeakyReLUBp;
import org.nd4j.linalg.factory.Nd4j;

public class ActivationLReLU
extends BaseActivationFunction {
    public static final double DEFAULT_ALPHA = 0.01;
    private double alpha;

    public ActivationLReLU() {
        this(0.01);
    }

    public ActivationLReLU(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public INDArray getActivation(INDArray in, boolean training) {
        Nd4j.getExecutioner().execAndReturn(new LeakyReLU(in, this.alpha));
        return in;
    }

    @Override
    public Pair<INDArray, INDArray> backprop(INDArray in, INDArray epsilon) {
        this.assertShape(in, epsilon);
        Nd4j.getExecutioner().execAndReturn(new LeakyReLUBp(in, epsilon, in, this.alpha));
        return new Pair<INDArray, Object>(in, null);
    }

    public String toString() {
        return "leakyrelu(a=" + this.alpha + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivationLReLU)) {
            return false;
        }
        ActivationLReLU other = (ActivationLReLU)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getAlpha(), other.getAlpha()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActivationLReLU;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $alpha = Double.doubleToLongBits(this.getAlpha());
        result = result * 59 + (int)($alpha >>> 32 ^ $alpha);
        return result;
    }

    public double getAlpha() {
        return this.alpha;
    }
}

