/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.workspace;

import java.util.List;
import java.util.Queue;
import lombok.NonNull;
import org.nd4j.jita.workspace.CudaWorkspace;
import org.nd4j.linalg.api.memory.Deallocator;
import org.nd4j.linalg.api.memory.enums.MemoryKind;
import org.nd4j.linalg.api.memory.pointers.PointersPair;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaWorkspaceDeallocator
implements Deallocator {
    private static final Logger log = LoggerFactory.getLogger(CudaWorkspaceDeallocator.class);
    private PointersPair pointersPair;
    private Queue<PointersPair> pinnedPointers;
    private List<PointersPair> externalPointers;

    public CudaWorkspaceDeallocator(@NonNull CudaWorkspace workspace) {
        if (workspace == null) {
            throw new NullPointerException("workspace is marked non-null but is null");
        }
        this.pointersPair = workspace.workspace();
        this.pinnedPointers = workspace.pinnedPointers();
        this.externalPointers = workspace.externalPointers();
    }

    @Override
    public void deallocate() {
        log.trace("Deallocating CUDA workspace");
        if (this.pointersPair != null) {
            if (this.pointersPair.getDevicePointer() != null) {
                Nd4j.getMemoryManager().release(this.pointersPair.getDevicePointer(), MemoryKind.DEVICE);
            }
            if (this.pointersPair.getHostPointer() != null) {
                Nd4j.getMemoryManager().release(this.pointersPair.getHostPointer(), MemoryKind.HOST);
            }
        }
        for (PointersPair pair2 : this.externalPointers) {
            if (pair2 == null) continue;
            if (pair2.getHostPointer() != null) {
                Nd4j.getMemoryManager().release(pair2.getHostPointer(), MemoryKind.HOST);
            }
            if (pair2.getDevicePointer() == null) continue;
            Nd4j.getMemoryManager().release(pair2.getDevicePointer(), MemoryKind.DEVICE);
        }
        for (PointersPair pair2 : this.externalPointers) {
            if (pair2 == null) continue;
            if (pair2.getHostPointer() != null) {
                Nd4j.getMemoryManager().release(pair2.getHostPointer(), MemoryKind.HOST);
            }
            if (pair2.getDevicePointer() == null) continue;
            Nd4j.getMemoryManager().release(pair2.getDevicePointer(), MemoryKind.DEVICE);
        }
        PointersPair pair = null;
        while ((pair = this.pinnedPointers.poll()) != null) {
            if (pair.getHostPointer() != null) {
                Nd4j.getMemoryManager().release(pair.getHostPointer(), MemoryKind.HOST);
            }
            if (pair.getDevicePointer() == null) continue;
            Nd4j.getMemoryManager().release(pair.getDevicePointer(), MemoryKind.DEVICE);
        }
    }
}

