/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.pointers;

import org.bytedeco.javacpp.BooleanPointer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudaPointer
extends Pointer {
    private static Logger logger = LoggerFactory.getLogger(CudaPointer.class);

    public CudaPointer(Pointer pointer) {
        this.address = pointer.address();
        this.capacity = pointer.capacity();
        this.limit = pointer.limit();
        this.position = pointer.position();
    }

    public CudaPointer(Pointer pointer, long capacity) {
        this.address = pointer.address();
        this.capacity = capacity;
        this.limit = capacity;
        this.position = 0L;
    }

    public CudaPointer(Pointer pointer, long capacity, long byteOffset) {
        this.address = pointer.address() + byteOffset;
        this.capacity = capacity;
        this.limit = capacity;
        this.position = 0L;
    }

    public CudaPointer(long address) {
        this.address = address;
    }

    public CudaPointer(long address, long capacity) {
        this.address = address;
        this.capacity = capacity;
        this.limit = capacity;
        this.position = 0L;
    }

    public Pointer asNativePointer() {
        return new Pointer(this);
    }

    public FloatPointer asFloatPointer() {
        return new FloatPointer(this);
    }

    public LongPointer asLongPointer() {
        return new LongPointer(this);
    }

    public DoublePointer asDoublePointer() {
        return new DoublePointer(this);
    }

    public IntPointer asIntPointer() {
        return new IntPointer(this);
    }

    public ShortPointer asShortPointer() {
        return new ShortPointer(this);
    }

    public BytePointer asBytePointer() {
        return new BytePointer(this);
    }

    public BooleanPointer asBooleanPointer() {
        return new BooleanPointer(this);
    }

    public long getNativePointer() {
        return this.address();
    }

    @Override
    public int sizeof() {
        return 4;
    }
}

