/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.evaluation.curves;

import java.util.Arrays;
import org.nd4j.common.base.Preconditions;
import org.nd4j.evaluation.curves.BaseCurve;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class RocCurve
extends BaseCurve {
    private double[] threshold;
    private double[] fpr;
    private double[] tpr;
    private Double auc;

    public RocCurve(@JsonProperty(value="threshold") double[] threshold, @JsonProperty(value="fpr") double[] fpr, @JsonProperty(value="tpr") double[] tpr) {
        this.threshold = threshold;
        this.fpr = fpr;
        this.tpr = tpr;
    }

    @Override
    public int numPoints() {
        return this.threshold.length;
    }

    @Override
    public double[] getX() {
        return this.fpr;
    }

    @Override
    public double[] getY() {
        return this.tpr;
    }

    @Override
    public String getTitle() {
        return "ROC (Area=" + this.format(this.calculateAUC(), 4) + ")";
    }

    public double getThreshold(int i) {
        Preconditions.checkArgument(i >= 0 && i < this.threshold.length, "Invalid index: " + i);
        return this.threshold[i];
    }

    public double getTruePositiveRate(int i) {
        Preconditions.checkArgument(i >= 0 && i < this.tpr.length, "Invalid index: " + i);
        return this.tpr[i];
    }

    public double getFalsePositiveRate(int i) {
        Preconditions.checkArgument(i >= 0 && i < this.fpr.length, "Invalid index: " + i);
        return this.fpr[i];
    }

    public double calculateAUC() {
        if (this.auc != null) {
            return this.auc;
        }
        this.auc = this.calculateArea();
        return this.auc;
    }

    public static RocCurve fromJson(String json) {
        return RocCurve.fromJson(json, RocCurve.class);
    }

    public static RocCurve fromYaml(String yaml) {
        return RocCurve.fromYaml(yaml, RocCurve.class);
    }

    public double[] getThreshold() {
        return this.threshold;
    }

    public double[] getFpr() {
        return this.fpr;
    }

    public double[] getTpr() {
        return this.tpr;
    }

    public Double getAuc() {
        return this.auc;
    }

    public void setThreshold(double[] threshold) {
        this.threshold = threshold;
    }

    public void setFpr(double[] fpr) {
        this.fpr = fpr;
    }

    public void setTpr(double[] tpr) {
        this.tpr = tpr;
    }

    public void setAuc(Double auc) {
        this.auc = auc;
    }

    public String toString() {
        return "RocCurve(threshold=" + Arrays.toString(this.getThreshold()) + ", fpr=" + Arrays.toString(this.getFpr()) + ", tpr=" + Arrays.toString(this.getTpr()) + ", auc=" + this.getAuc() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RocCurve)) {
            return false;
        }
        RocCurve other = (RocCurve)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getThreshold(), other.getThreshold())) {
            return false;
        }
        if (!Arrays.equals(this.getFpr(), other.getFpr())) {
            return false;
        }
        return Arrays.equals(this.getTpr(), other.getTpr());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RocCurve;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getThreshold());
        result = result * 59 + Arrays.hashCode(this.getFpr());
        result = result * 59 + Arrays.hashCode(this.getTpr());
        return result;
    }
}

