/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.common.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ValidationResult
implements Serializable {
    private String formatType;
    private Class<?> formatClass;
    private String path;
    private boolean valid;
    private List<String> issues;
    private Throwable exception;

    public String toString() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.formatType != null) {
            lines.add("Format type: " + this.formatType);
        }
        if (this.formatClass != null) {
            lines.add("Format class: " + this.formatClass.getName());
        }
        if (this.path != null) {
            lines.add("Path: " + this.path);
        }
        lines.add("Format valid: " + this.valid);
        if (this.issues != null && !this.issues.isEmpty()) {
            if (this.issues.size() == 1) {
                ValidationResult.addWithIndent(this.issues.get(0), lines, "Issue: ", "       ");
            } else {
                lines.add("Issues:");
                for (String s : this.issues) {
                    ValidationResult.addWithIndent(s, lines, "- ", "  ");
                }
            }
        }
        if (this.exception != null) {
            String ex = ExceptionUtils.getStackTrace(this.exception);
            lines.add("Stack Trace:");
            ValidationResult.addWithIndent(ex, lines, "  ", "  ");
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : lines) {
            if (!first) {
                sb.append("\n");
            }
            sb.append(s);
            first = false;
        }
        return sb.toString();
    }

    protected static void addWithIndent(String toAdd, List<String> list, String firstLineIndent, String laterLineIndent) {
        String[] split = toAdd.split("\n");
        boolean first = true;
        for (String issueLine : split) {
            list.add((first ? firstLineIndent : laterLineIndent) + issueLine);
            first = false;
        }
    }

    public static ValidationResultBuilder builder() {
        return new ValidationResultBuilder();
    }

    public ValidationResult(String formatType, Class<?> formatClass, String path, boolean valid, List<String> issues, Throwable exception) {
        this.formatType = formatType;
        this.formatClass = formatClass;
        this.path = path;
        this.valid = valid;
        this.issues = issues;
        this.exception = exception;
    }

    public ValidationResult() {
    }

    public String getFormatType() {
        return this.formatType;
    }

    public Class<?> getFormatClass() {
        return this.formatClass;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<String> getIssues() {
        return this.issues;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    public void setFormatClass(Class<?> formatClass) {
        this.formatClass = formatClass;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setIssues(List<String> issues) {
        this.issues = issues;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$formatType = this.getFormatType();
        String other$formatType = other.getFormatType();
        if (this$formatType == null ? other$formatType != null : !this$formatType.equals(other$formatType)) {
            return false;
        }
        Class<?> this$formatClass = this.getFormatClass();
        Class<?> other$formatClass = other.getFormatClass();
        if (this$formatClass == null ? other$formatClass != null : !this$formatClass.equals(other$formatClass)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        List<String> this$issues = this.getIssues();
        List<String> other$issues = other.getIssues();
        if (this$issues == null ? other$issues != null : !((Object)this$issues).equals(other$issues)) {
            return false;
        }
        Throwable this$exception = this.getException();
        Throwable other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $formatType = this.getFormatType();
        result = result * 59 + ($formatType == null ? 43 : $formatType.hashCode());
        Class<?> $formatClass = this.getFormatClass();
        result = result * 59 + ($formatClass == null ? 43 : $formatClass.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        result = result * 59 + (this.isValid() ? 79 : 97);
        List<String> $issues = this.getIssues();
        result = result * 59 + ($issues == null ? 43 : ((Object)$issues).hashCode());
        Throwable $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    public static class ValidationResultBuilder {
        private String formatType;
        private Class<?> formatClass;
        private String path;
        private boolean valid;
        private List<String> issues;
        private Throwable exception;

        ValidationResultBuilder() {
        }

        public ValidationResultBuilder formatType(String formatType) {
            this.formatType = formatType;
            return this;
        }

        public ValidationResultBuilder formatClass(Class<?> formatClass) {
            this.formatClass = formatClass;
            return this;
        }

        public ValidationResultBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ValidationResultBuilder valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        public ValidationResultBuilder issues(List<String> issues) {
            this.issues = issues;
            return this;
        }

        public ValidationResultBuilder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public ValidationResult build() {
            return new ValidationResult(this.formatType, this.formatClass, this.path, this.valid, this.issues, this.exception);
        }

        public String toString() {
            return "ValidationResult.ValidationResultBuilder(formatType=" + this.formatType + ", formatClass=" + this.formatClass + ", path=" + this.path + ", valid=" + this.valid + ", issues=" + this.issues + ", exception=" + this.exception + ")";
        }
    }
}

