/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.listeners;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import org.nd4j.autodiff.listeners.Operation;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.shade.guava.collect.Sets;

public class ListenerVariables {
    @NonNull
    private Set<String> trainingVariables;
    @NonNull
    private Set<String> validationVariables;
    @NonNull
    private Set<String> evaluationVariables;
    @NonNull
    private Set<String> inferenceVariables;

    public static ListenerVariables empty() {
        return ListenerVariables.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Set<String> trainingVariables() {
        return this.trainingVariables;
    }

    public Set<String> validationVariables() {
        return this.validationVariables;
    }

    public Set<String> evaluationVariables() {
        return this.evaluationVariables;
    }

    public Set<String> inferenceVariables() {
        return this.inferenceVariables;
    }

    public Set<String> requiredVariables(Operation op) {
        switch (op) {
            case TRAINING: {
                return this.trainingVariables;
            }
            case TRAINING_VALIDATION: {
                return this.validationVariables;
            }
            case INFERENCE: {
                return this.inferenceVariables;
            }
            case EVALUATION: {
                return this.evaluationVariables;
            }
        }
        throw new IllegalArgumentException("Unknown operation " + (Object)((Object)op));
    }

    private ListenerVariables() {
    }

    public ListenerVariables merge(ListenerVariables other) {
        return new ListenerVariables(Sets.newHashSet(Sets.union(this.trainingVariables, other.trainingVariables)), Sets.newHashSet(Sets.union(this.validationVariables, other.validationVariables)), Sets.newHashSet(Sets.union(this.evaluationVariables, other.evaluationVariables)), Sets.newHashSet(Sets.union(this.inferenceVariables, other.inferenceVariables)));
    }

    public ListenerVariables(@NonNull Set<String> trainingVariables, @NonNull Set<String> validationVariables, @NonNull Set<String> evaluationVariables, @NonNull Set<String> inferenceVariables) {
        if (trainingVariables == null) {
            throw new NullPointerException("trainingVariables is marked non-null but is null");
        }
        if (validationVariables == null) {
            throw new NullPointerException("validationVariables is marked non-null but is null");
        }
        if (evaluationVariables == null) {
            throw new NullPointerException("evaluationVariables is marked non-null but is null");
        }
        if (inferenceVariables == null) {
            throw new NullPointerException("inferenceVariables is marked non-null but is null");
        }
        this.trainingVariables = trainingVariables;
        this.validationVariables = validationVariables;
        this.evaluationVariables = evaluationVariables;
        this.inferenceVariables = inferenceVariables;
    }

    @NonNull
    public Set<String> getTrainingVariables() {
        return this.trainingVariables;
    }

    @NonNull
    public Set<String> getValidationVariables() {
        return this.validationVariables;
    }

    @NonNull
    public Set<String> getEvaluationVariables() {
        return this.evaluationVariables;
    }

    @NonNull
    public Set<String> getInferenceVariables() {
        return this.inferenceVariables;
    }

    public static class Builder {
        @NonNull
        private Set<String> trainingVariables = new HashSet<String>();
        @NonNull
        private Set<String> validationVariables = new HashSet<String>();
        @NonNull
        private Set<String> evaluationVariables = new HashSet<String>();
        @NonNull
        private Set<String> inferenceVariables = new HashSet<String>();

        public Builder requireVariables(@NonNull Operation op, String ... variables) {
            if (op == null) {
                throw new NullPointerException("op is marked non-null but is null");
            }
            if (variables == null) {
                throw new NullPointerException("variables is marked non-null but is null");
            }
            switch (op) {
                case TRAINING: {
                    this.trainingVariables.addAll(Arrays.asList(variables));
                    break;
                }
                case TRAINING_VALIDATION: {
                    this.validationVariables.addAll(Arrays.asList(variables));
                    break;
                }
                case INFERENCE: {
                    this.inferenceVariables.addAll(Arrays.asList(variables));
                    break;
                }
                case EVALUATION: {
                    this.evaluationVariables.addAll(Arrays.asList(variables));
                }
            }
            return this;
        }

        public Builder requireVariables(@NonNull Operation op, SDVariable ... variables) {
            if (op == null) {
                throw new NullPointerException("op is marked non-null but is null");
            }
            if (variables == null) {
                throw new NullPointerException("variables is marked non-null but is null");
            }
            String[] names = new String[variables.length];
            for (int i = 0; i < variables.length; ++i) {
                names[i] = variables[i].name();
            }
            return this.requireVariables(op, names);
        }

        public Builder trainingVariables(String ... variables) {
            if (variables == null) {
                throw new NullPointerException("variables is marked non-null but is null");
            }
            return this.requireVariables(Operation.TRAINING, variables);
        }

        public Builder trainingVariables(SDVariable ... variables) {
            if (variables == null) {
                throw new NullPointerException("variables is marked non-null but is null");
            }
            return this.requireVariables(Operation.TRAINING, variables);
        }

        public Builder validationVariables(String ... variables) {
            if (variables == null) {
                throw new NullPointerException("variables is marked non-null but is null");
            }
            return this.requireVariables(Operation.TRAINING_VALIDATION, variables);
        }

        public Builder validationVariables(SDVariable ... variables) {
            if (variables == null) {
                throw new NullPointerException("variables is marked non-null but is null");
            }
            return this.requireVariables(Operation.TRAINING_VALIDATION, variables);
        }

        public Builder inferenceVariables(String ... variables) {
            if (variables == null) {
                throw new NullPointerException("variables is marked non-null but is null");
            }
            return this.requireVariables(Operation.INFERENCE, variables);
        }

        public Builder inferenceVariables(SDVariable ... variables) {
            if (variables == null) {
                throw new NullPointerException("variables is marked non-null but is null");
            }
            return this.requireVariables(Operation.INFERENCE, variables);
        }

        public Builder evaluationVariables(String ... variables) {
            if (variables == null) {
                throw new NullPointerException("variables is marked non-null but is null");
            }
            return this.requireVariables(Operation.EVALUATION, variables);
        }

        public Builder evaluationVariables(SDVariable ... variables) {
            if (variables == null) {
                throw new NullPointerException("variables is marked non-null but is null");
            }
            return this.requireVariables(Operation.EVALUATION, variables);
        }

        public ListenerVariables build() {
            return new ListenerVariables(this.trainingVariables, this.validationVariables, this.evaluationVariables, this.inferenceVariables);
        }

        @NonNull
        public Set<String> getTrainingVariables() {
            return this.trainingVariables;
        }

        @NonNull
        public Set<String> getValidationVariables() {
            return this.validationVariables;
        }

        @NonNull
        public Set<String> getEvaluationVariables() {
            return this.evaluationVariables;
        }

        @NonNull
        public Set<String> getInferenceVariables() {
            return this.inferenceVariables;
        }

        public void setTrainingVariables(@NonNull Set<String> trainingVariables) {
            if (trainingVariables == null) {
                throw new NullPointerException("trainingVariables is marked non-null but is null");
            }
            this.trainingVariables = trainingVariables;
        }

        public void setValidationVariables(@NonNull Set<String> validationVariables) {
            if (validationVariables == null) {
                throw new NullPointerException("validationVariables is marked non-null but is null");
            }
            this.validationVariables = validationVariables;
        }

        public void setEvaluationVariables(@NonNull Set<String> evaluationVariables) {
            if (evaluationVariables == null) {
                throw new NullPointerException("evaluationVariables is marked non-null but is null");
            }
            this.evaluationVariables = evaluationVariables;
        }

        public void setInferenceVariables(@NonNull Set<String> inferenceVariables) {
            if (inferenceVariables == null) {
                throw new NullPointerException("inferenceVariables is marked non-null but is null");
            }
            this.inferenceVariables = inferenceVariables;
        }
    }
}

