/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.neoitertools.generators;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import net.ericaro.neoitertools.Generator;
import net.ericaro.neoitertools.Itertools;
import net.ericaro.neoitertools.Lambda;
import net.ericaro.neoitertools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByGenerator<K, T>
implements Generator<Pair<K, Generator<T>>> {
    private Generator<T> generator;
    private Lambda<T, K> keyMapper;
    K currentKey;
    T currentValue;
    boolean itsOver = false;

    public GroupByGenerator(Generator<T> generator, Lambda<T, K> keyMapper) {
        this.generator = generator;
        this.keyMapper = keyMapper;
        try {
            this.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public Pair<K, Generator<T>> next() throws NoSuchElementException {
        if (this.itsOver) {
            throw new NoSuchElementException();
        }
        LinkedList<T> values = new LinkedList<T>();
        K targetKey = this.currentKey;
        try {
            while (this.currentKey == targetKey || this.currentKey.equals(targetKey)) {
                values.add(this.currentValue);
                this.currentValue = this.generator.next();
                this.currentKey = this.keyMapper.map(this.currentValue);
            }
        }
        catch (NoSuchElementException e) {
            this.itsOver = true;
        }
        return new Pair(targetKey, Itertools.iter(values));
    }
}

