/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinGDI;
import java.awt.image.BufferedImage;

public class GDI32Util {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static BufferedImage getScreenshot(WinDef.HWND target) {
        rect = new WinDef.RECT();
        if (!User32.INSTANCE.GetWindowRect(target, rect)) {
            throw new Win32Exception(Native.getLastError());
        }
        jRectangle = rect.toRectangle();
        windowWidth = jRectangle.width;
        windowHeight = jRectangle.height;
        if (windowWidth == 0 || windowHeight == 0) {
            throw new IllegalStateException("Window width and/or height were 0 even though GetWindowRect did not appear to fail.");
        }
        hdcTarget = User32.INSTANCE.GetDC(target);
        if (hdcTarget == null) {
            throw new Win32Exception(Native.getLastError());
        }
        we = null;
        hdcTargetMem = null;
        hBitmap = null;
        hOriginal = null;
        image = null;
        try {
            image = new BufferedImage(windowWidth, windowHeight, 1);
            hdcTargetMem = GDI32.INSTANCE.CreateCompatibleDC(hdcTarget);
            if (hdcTargetMem == null) {
                throw new Win32Exception(Native.getLastError());
            }
            hBitmap = GDI32.INSTANCE.CreateCompatibleBitmap(hdcTarget, windowWidth, windowHeight);
            if (hBitmap == null) {
                throw new Win32Exception(Native.getLastError());
            }
            hOriginal = GDI32.INSTANCE.SelectObject(hdcTargetMem, hBitmap);
            if (hOriginal == null) {
                throw new Win32Exception(Native.getLastError());
            }
            if (!GDI32.INSTANCE.BitBlt(hdcTargetMem, 0, 0, windowWidth, windowHeight, hdcTarget, 0, 0, 0xCC0020)) {
                throw new Win32Exception(Native.getLastError());
            }
            bmi = new WinGDI.BITMAPINFO();
            bmi.bmiHeader.biWidth = windowWidth;
            bmi.bmiHeader.biHeight = -windowHeight;
            bmi.bmiHeader.biPlanes = 1;
            bmi.bmiHeader.biBitCount = (short)32;
            bmi.bmiHeader.biCompression = 0;
            buffer = new Memory(windowWidth * windowHeight * 4);
            resultOfDrawing = GDI32.INSTANCE.GetDIBits(hdcTarget, hBitmap, 0, windowHeight, buffer, bmi, 0);
            if (resultOfDrawing == 0 || resultOfDrawing == 87) {
                throw new Win32Exception(Native.getLastError());
            }
            image.setRGB(0, 0, windowWidth, windowHeight, buffer.getIntArray(0L, windowWidth * windowHeight), 0, windowWidth);
        }
        catch (Win32Exception e) {
            try {
                we = e;
            }
            catch (Throwable var14_17) {
                if (hOriginal != null && ((result = GDI32.INSTANCE.SelectObject(hdcTargetMem, hOriginal)) == null || WinGDI.HGDI_ERROR.equals(result))) {
                    ex = new Win32Exception(Native.getLastError());
                    if (we != null) {
                        ex.addSuppressed(we);
                    }
                    we = ex;
                }
                if (hBitmap != null && !GDI32.INSTANCE.DeleteObject(hBitmap)) {
                    ex = new Win32Exception(Native.getLastError());
                    if (we != null) {
                        ex.addSuppressed(we);
                    }
                    we = ex;
                }
                if (hdcTargetMem != null && !GDI32.INSTANCE.DeleteDC(hdcTargetMem)) {
                    ex = new Win32Exception(Native.getLastError());
                    if (we != null) {
                        ex.addSuppressed(we);
                    }
                    we = ex;
                }
                if (hdcTarget != null && 0 == User32.INSTANCE.ReleaseDC(target, hdcTarget)) {
                    throw new IllegalStateException("Device context did not release properly.");
                }
                throw var14_17;
            }
            if (hOriginal != null && ((result = GDI32.INSTANCE.SelectObject(hdcTargetMem, hOriginal)) == null || WinGDI.HGDI_ERROR.equals(result))) {
                ex = new Win32Exception(Native.getLastError());
                if (we != null) {
                    ex.addSuppressed(we);
                }
                we = ex;
            }
            if (hBitmap != null && !GDI32.INSTANCE.DeleteObject(hBitmap)) {
                ex = new Win32Exception(Native.getLastError());
                if (we != null) {
                    ex.addSuppressed(we);
                }
                we = ex;
            }
            if (hdcTargetMem != null && !GDI32.INSTANCE.DeleteDC(hdcTargetMem)) {
                ex = new Win32Exception(Native.getLastError());
                if (we != null) {
                    ex.addSuppressed(we);
                }
                we = ex;
            }
            if (hdcTarget != null && 0 == User32.INSTANCE.ReleaseDC(target, hdcTarget)) {
                throw new IllegalStateException("Device context did not release properly.");
            } else {
                ** GOTO lbl99
            }
        }
        if (hOriginal != null && ((result = GDI32.INSTANCE.SelectObject(hdcTargetMem, hOriginal)) == null || WinGDI.HGDI_ERROR.equals(result))) {
            ex = new Win32Exception(Native.getLastError());
            if (we != null) {
                ex.addSuppressed(we);
            }
            we = ex;
        }
        if (hBitmap != null && !GDI32.INSTANCE.DeleteObject(hBitmap)) {
            ex = new Win32Exception(Native.getLastError());
            if (we != null) {
                ex.addSuppressed(we);
            }
            we = ex;
        }
        if (hdcTargetMem != null && !GDI32.INSTANCE.DeleteDC(hdcTargetMem)) {
            ex = new Win32Exception(Native.getLastError());
            if (we != null) {
                ex.addSuppressed(we);
            }
            we = ex;
        }
        if (hdcTarget != null && 0 == User32.INSTANCE.ReleaseDC(target, hdcTarget)) {
            throw new IllegalStateException("Device context did not release properly.");
        }
        if (we != null) {
            throw we;
        }
        return image;
    }
}

