/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.MergeVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.SpaceToDepthLayer;
import org.deeplearning4j.nn.conf.layers.objdetect.Yolo2OutputLayer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.deeplearning4j.zoo.model.helper.DarknetHelper;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.config.Adam;
import org.nd4j.linalg.learning.config.IUpdater;

public class YOLO2
extends ZooModel {
    public static final double[][] DEFAULT_PRIOR_BOXES = new double[][]{{0.57273, 0.677385}, {1.87446, 2.06253}, {3.33843, 5.47434}, {7.88282, 3.52778}, {9.77052, 9.16828}};
    private int nBoxes;
    private double[][] priorBoxes;
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private YOLO2() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return DL4JResources.getURLString((String)"models/yolo2_dl4j_inference.v3.zip");
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return 3658373840L;
        }
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraphConfiguration conf() {
        INDArray priors = Nd4j.create((double[][])this.priorBoxes);
        ComputationGraphConfiguration.GraphBuilder graphBuilder = new NeuralNetConfiguration.Builder().seed(this.seed).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).gradientNormalization(GradientNormalization.RenormalizeL2PerLayer).gradientNormalizationThreshold(1.0).updater(this.updater).l2(1.0E-5).activation(Activation.IDENTITY).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).cudnnAlgoMode(this.cudnnAlgoMode).graphBuilder().addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((long)this.inputShape[2], (long)this.inputShape[1], (long)this.inputShape[0])});
        DarknetHelper.addLayers(graphBuilder, 1, 3, this.inputShape[0], 32, 2);
        DarknetHelper.addLayers(graphBuilder, 2, 3, 32, 64, 2);
        DarknetHelper.addLayers(graphBuilder, 3, 3, 64, 128, 0);
        DarknetHelper.addLayers(graphBuilder, 4, 1, 128, 64, 0);
        DarknetHelper.addLayers(graphBuilder, 5, 3, 64, 128, 2);
        DarknetHelper.addLayers(graphBuilder, 6, 3, 128, 256, 0);
        DarknetHelper.addLayers(graphBuilder, 7, 1, 256, 128, 0);
        DarknetHelper.addLayers(graphBuilder, 8, 3, 128, 256, 2);
        DarknetHelper.addLayers(graphBuilder, 9, 3, 256, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 10, 1, 512, 256, 0);
        DarknetHelper.addLayers(graphBuilder, 11, 3, 256, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 12, 1, 512, 256, 0);
        DarknetHelper.addLayers(graphBuilder, 13, 3, 256, 512, 2);
        DarknetHelper.addLayers(graphBuilder, 14, 3, 512, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 15, 1, 1024, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 16, 3, 512, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 17, 1, 1024, 512, 0);
        DarknetHelper.addLayers(graphBuilder, 18, 3, 512, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 19, 3, 1024, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 20, 3, 1024, 1024, 0);
        DarknetHelper.addLayers(graphBuilder, 21, "activation_13", 1, 512, 64, 0, 0);
        graphBuilder.addLayer("rearrange_21", (Layer)new SpaceToDepthLayer.Builder(2).build(), new String[]{"activation_21"}).addVertex("concatenate_21", (GraphVertex)new MergeVertex(), new String[]{"rearrange_21", "activation_20"});
        DarknetHelper.addLayers(graphBuilder, 22, "concatenate_21", 3, 1280, 1024, 0, 0);
        graphBuilder.addLayer("convolution2d_23", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{1, 1}).nIn(1024)).nOut(this.nBoxes * (5 + this.numClasses))).weightInit(WeightInit.XAVIER)).stride(new int[]{1, 1}).convolutionMode(ConvolutionMode.Same)).weightInit(WeightInit.RELU)).activation(Activation.IDENTITY)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"activation_22"}).addLayer("outputs", (Layer)new Yolo2OutputLayer.Builder().boundingBoxPriors(priors).build(), new String[]{"convolution2d_23"}).setOutputs(new String[]{"outputs"});
        return graphBuilder.build();
    }

    public ComputationGraph init() {
        ComputationGraph model = new ComputationGraph(this.conf());
        model.init();
        return model;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static int $default$nBoxes() {
        return 5;
    }

    private static double[][] $default$priorBoxes() {
        return DEFAULT_PRIOR_BOXES;
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 608, 608};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static IUpdater $default$updater() {
        return new Adam(0.001);
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static YOLO2Builder builder() {
        return new YOLO2Builder();
    }

    public YOLO2(int nBoxes, double[][] priorBoxes, long seed, int[] inputShape, int numClasses, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.nBoxes = nBoxes;
        this.priorBoxes = priorBoxes;
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public int getNBoxes() {
        return this.nBoxes;
    }

    public double[][] getPriorBoxes() {
        return this.priorBoxes;
    }

    public static class YOLO2Builder {
        private boolean nBoxes$set;
        private int nBoxes$value;
        private boolean priorBoxes$set;
        private double[][] priorBoxes$value;
        private boolean seed$set;
        private long seed$value;
        private boolean inputShape$set;
        private int[] inputShape$value;
        private boolean numClasses$set;
        private int numClasses$value;
        private boolean updater$set;
        private IUpdater updater$value;
        private boolean cacheMode$set;
        private CacheMode cacheMode$value;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode$value;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode$value;

        YOLO2Builder() {
        }

        public YOLO2Builder nBoxes(int nBoxes) {
            this.nBoxes$value = nBoxes;
            this.nBoxes$set = true;
            return this;
        }

        public YOLO2Builder priorBoxes(double[][] priorBoxes) {
            this.priorBoxes$value = priorBoxes;
            this.priorBoxes$set = true;
            return this;
        }

        public YOLO2Builder seed(long seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public YOLO2Builder inputShape(int[] inputShape) {
            this.inputShape$value = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public YOLO2Builder numClasses(int numClasses) {
            this.numClasses$value = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public YOLO2Builder updater(IUpdater updater) {
            this.updater$value = updater;
            this.updater$set = true;
            return this;
        }

        public YOLO2Builder cacheMode(CacheMode cacheMode) {
            this.cacheMode$value = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public YOLO2Builder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode$value = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public YOLO2Builder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode$value = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public YOLO2 build() {
            int nBoxes$value = this.nBoxes$value;
            if (!this.nBoxes$set) {
                nBoxes$value = YOLO2.$default$nBoxes();
            }
            double[][] priorBoxes$value = this.priorBoxes$value;
            if (!this.priorBoxes$set) {
                priorBoxes$value = YOLO2.$default$priorBoxes();
            }
            long seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = YOLO2.$default$seed();
            }
            int[] inputShape$value = this.inputShape$value;
            if (!this.inputShape$set) {
                inputShape$value = YOLO2.$default$inputShape();
            }
            int numClasses$value = this.numClasses$value;
            if (!this.numClasses$set) {
                numClasses$value = YOLO2.$default$numClasses();
            }
            IUpdater updater$value = this.updater$value;
            if (!this.updater$set) {
                updater$value = YOLO2.$default$updater();
            }
            CacheMode cacheMode$value = this.cacheMode$value;
            if (!this.cacheMode$set) {
                cacheMode$value = YOLO2.$default$cacheMode();
            }
            WorkspaceMode workspaceMode$value = this.workspaceMode$value;
            if (!this.workspaceMode$set) {
                workspaceMode$value = YOLO2.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode$value = this.cudnnAlgoMode$value;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode$value = YOLO2.$default$cudnnAlgoMode();
            }
            return new YOLO2(nBoxes$value, priorBoxes$value, seed$value, inputShape$value, numClasses$value, updater$value, cacheMode$value, workspaceMode$value, cudnnAlgoMode$value);
        }

        public String toString() {
            return "YOLO2.YOLO2Builder(nBoxes$value=" + this.nBoxes$value + ", priorBoxes$value=" + Arrays.deepToString((Object[])this.priorBoxes$value) + ", seed$value=" + this.seed$value + ", inputShape$value=" + Arrays.toString(this.inputShape$value) + ", numClasses$value=" + this.numClasses$value + ", updater$value=" + this.updater$value + ", cacheMode$value=" + this.cacheMode$value + ", workspaceMode$value=" + this.workspaceMode$value + ", cudnnAlgoMode$value=" + this.cudnnAlgoMode$value + ")";
        }
    }
}

